/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.federation.config;

import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryFactory;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryRegistry;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailFactory;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.federation.Federation;
import org.eclipse.rdf4j.sail.federation.config.FederationConfig;

public class FederationFactory
implements SailFactory {
    public static final String SAIL_TYPE = "openrdf:Federation";

    @Override
    public String getSailType() {
        return SAIL_TYPE;
    }

    @Override
    public SailImplConfig getConfig() {
        return new FederationConfig();
    }

    @Override
    public Sail getSail(SailImplConfig config) throws SailConfigException {
        if (!SAIL_TYPE.equals(config.getType())) {
            throw new SailConfigException("Invalid Sail type: " + config.getType());
        }
        assert (config instanceof FederationConfig);
        FederationConfig cfg = (FederationConfig)config;
        Federation sail = new Federation();
        for (RepositoryImplConfig member : cfg.getMembers()) {
            RepositoryFactory factory = (RepositoryFactory)RepositoryRegistry.getInstance().get(member.getType()).orElseThrow(() -> new SailConfigException("Unsupported repository type: " + config.getType()));
            try {
                sail.addMember(factory.getRepository(member));
            }
            catch (RepositoryConfigException e) {
                throw new SailConfigException(e);
            }
        }
        sail.setLocalPropertySpace(cfg.getLocalPropertySpace());
        sail.setDistinct(cfg.isDistinct());
        sail.setReadOnly(cfg.isReadOnly());
        return sail;
    }
}

