/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.Objects;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;

public class Select
implements PlanNode {
    private final SailConnection connection;
    private final String query;
    private boolean printed = false;

    public Select(SailConnection connection, String query) {
        this.connection = connection;
        this.query = "select * where { " + query + "} order by ?a";
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new CloseableIteration<Tuple, SailException>(){
            CloseableIteration<? extends BindingSet, QueryEvaluationException> bindingSet;
            {
                QueryParserFactory queryParserFactory = (QueryParserFactory)QueryParserRegistry.getInstance().get(QueryLanguage.SPARQL).get();
                ParsedQuery parsedQuery = queryParserFactory.getParser().parseQuery(Select.this.query, null);
                this.bindingSet = Select.this.connection.evaluate(parsedQuery.getTupleExpr(), parsedQuery.getDataset(), new MapBindingSet(), true);
            }

            @Override
            public void close() throws SailException {
                this.bindingSet.close();
            }

            @Override
            public boolean hasNext() throws SailException {
                return this.bindingSet.hasNext();
            }

            @Override
            public Tuple next() throws SailException {
                return new Tuple((BindingSet)this.bindingSet.next());
            }

            @Override
            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return 0;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        if (this.connection instanceof MemoryStoreConnection) {
            stringBuilder.append(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()) + " -> " + this.getId()).append("\n");
        } else {
            stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId()).append("\n");
        }
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        return IteratorData.tripleBased;
    }

    public String toString() {
        return "Select{query='" + this.query + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Select select = (Select)o;
        return Objects.equals(this.connection instanceof MemoryStoreConnection ? ((MemoryStoreConnection)this.connection).getSail() : this.connection, select.connection instanceof MemoryStoreConnection ? ((MemoryStoreConnection)select.connection).getSail() : select.connection) && this.query.equals(select.query);
    }

    public int hashCode() {
        if (this.connection instanceof MemoryStoreConnection) {
            return Objects.hash(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()), this.query);
        }
        return Objects.hash(System.identityHashCode(this.connection), this.query);
    }
}

