/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.nquads;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.ntriples.NTriplesWriter;

public class NQuadsWriter
extends NTriplesWriter {
    public NQuadsWriter(OutputStream outputStream) {
        super(outputStream);
    }

    public NQuadsWriter(Writer writer) {
        super(writer);
    }

    @Override
    public RDFFormat getRDFFormat() {
        return RDFFormat.NQUADS;
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        if (!this.writingStarted) {
            throw new RuntimeException("Document writing has not yet been started");
        }
        try {
            this.writeValue(st.getSubject());
            this.writer.write(" ");
            this.writeValue(st.getPredicate());
            this.writer.write(" ");
            this.writeValue(st.getObject());
            if (null != st.getContext()) {
                this.writer.write(" ");
                this.writeValue(st.getContext());
            }
            this.writer.write(" .\n");
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }
}

