/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.query.algebra.UpdateExpr;
import org.eclipse.rdf4j.query.impl.AbstractParserUpdate;
import org.eclipse.rdf4j.query.parser.ParsedUpdate;
import org.eclipse.rdf4j.repository.sail.helpers.SailUpdateExecutor;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SailConnectionUpdate
extends AbstractParserUpdate {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final SailConnection con;
    private final ValueFactory vf;
    private final ParserConfig parserConfig;

    public SailConnectionUpdate(ParsedUpdate parsedUpdate, SailConnection con, ValueFactory vf, ParserConfig parserConfig) {
        super(parsedUpdate);
        this.con = con;
        this.vf = vf;
        this.parserConfig = parserConfig;
    }

    protected SailConnection getSailConnection() {
        return this.con;
    }

    public void execute() throws UpdateExecutionException {
        ParsedUpdate parsedUpdate = this.getParsedUpdate();
        List updateExprs = parsedUpdate.getUpdateExprs();
        Map datasetMapping = parsedUpdate.getDatasetMapping();
        SailUpdateExecutor executor = new SailUpdateExecutor(this.con, this.vf, this.parserConfig);
        for (UpdateExpr updateExpr : updateExprs) {
            Dataset activeDataset = this.getMergedDataset((Dataset)datasetMapping.get(updateExpr));
            try {
                boolean localTransaction = this.isLocalTransaction();
                if (localTransaction) {
                    this.beginLocalTransaction();
                }
                executor.executeUpdate(updateExpr, activeDataset, this.getBindings(), this.getIncludeInferred(), this.getMaxExecutionTime());
                if (!localTransaction) continue;
                this.commitLocalTransaction();
            }
            catch (RDF4JException e) {
                this.logger.warn("exception during update execution: ", (Throwable)e);
                if (updateExpr.isSilent()) continue;
                throw new UpdateExecutionException((Throwable)e);
            }
            catch (IOException e) {
                this.logger.warn("exception during update execution: ", (Throwable)e);
                if (updateExpr.isSilent()) continue;
                throw new UpdateExecutionException((Throwable)e);
            }
        }
    }

    private boolean isLocalTransaction() throws SailException {
        return !this.getSailConnection().isActive();
    }

    private void beginLocalTransaction() throws SailException {
        this.getSailConnection().begin();
    }

    private void commitLocalTransaction() throws SailException {
        this.getSailConnection().commit();
    }
}

