/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.elasticsearch;

import com.google.common.base.Function;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.vocabulary.GEOF;
import org.eclipse.rdf4j.sail.elasticsearch.ElasticsearchDocument;
import org.eclipse.rdf4j.sail.elasticsearch.ElasticsearchDocumentResult;
import org.eclipse.rdf4j.sail.lucene.DocumentDistance;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.search.SearchHit;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.distance.DistanceUtils;

public class ElasticsearchDocumentDistance
extends ElasticsearchDocumentResult
implements DocumentDistance {
    private final String geoPointField;
    private final IRI units;
    private final GeoPoint srcPoint;
    private final DistanceUnit unit;

    public ElasticsearchDocumentDistance(SearchHit hit, Function<? super String, ? extends SpatialContext> geoContextMapper, String geoPointField, IRI units, GeoPoint srcPoint, DistanceUnit unit) {
        super(hit, geoContextMapper);
        this.geoPointField = geoPointField;
        this.units = units;
        this.srcPoint = srcPoint;
        this.unit = unit;
    }

    @Override
    public double getDistance() {
        double distance;
        String geohash = (String)((ElasticsearchDocument)this.getDocument()).getSource().get(this.geoPointField);
        GeoPoint dstPoint = GeoPoint.fromGeohash((String)geohash);
        double unitDist = GeoDistance.ARC.calculate(this.srcPoint.getLat(), this.srcPoint.getLon(), dstPoint.getLat(), dstPoint.getLon(), this.unit);
        if (GEOF.UOM_METRE.equals((Object)this.units)) {
            distance = this.unit.toMeters(unitDist);
        } else if (GEOF.UOM_DEGREE.equals((Object)this.units)) {
            distance = unitDist / this.unit.getDistancePerDegree();
        } else if (GEOF.UOM_RADIAN.equals((Object)this.units)) {
            distance = DistanceUtils.dist2Radians((double)this.unit.convert(unitDist, DistanceUnit.KILOMETERS), (double)6371.0087714);
        } else if (GEOF.UOM_UNITY.equals((Object)this.units)) {
            distance = this.unit.convert(unitDist, DistanceUnit.KILOMETERS) / 20015.114352186374;
        } else {
            throw new UnsupportedOperationException("Unsupported units: " + this.units);
        }
        return distance;
    }
}

