/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.TupleHelper;

public class EqualsJoin
implements PlanNode {
    private PlanNode left;
    private PlanNode right;
    private boolean useAsFilter;
    private boolean printed = false;

    public EqualsJoin(PlanNode left, PlanNode right, boolean useAsFilter) {
        this.left = left;
        this.right = right;
        this.useAsFilter = useAsFilter;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new CloseableIteration<Tuple, SailException>(){
            CloseableIteration<Tuple, SailException> leftIterator;
            CloseableIteration<Tuple, SailException> rightIterator;
            Tuple next;
            Tuple nextLeft;
            Tuple nextRight;
            {
                this.leftIterator = EqualsJoin.this.left.iterator();
                this.rightIterator = EqualsJoin.this.right.iterator();
            }

            void calculateNext() {
                if (this.next != null) {
                    return;
                }
                if (this.nextLeft == null && this.leftIterator.hasNext()) {
                    this.nextLeft = (Tuple)this.leftIterator.next();
                }
                if (this.nextRight == null && this.rightIterator.hasNext()) {
                    this.nextRight = (Tuple)this.rightIterator.next();
                }
                if (this.nextLeft == null) {
                    return;
                }
                while (this.next == null) {
                    if (this.nextRight != null) {
                        if (this.nextLeft.line == this.nextRight.line || this.nextLeft.line.equals(this.nextRight.line)) {
                            if (EqualsJoin.this.useAsFilter) {
                                this.next = this.nextLeft;
                                this.next.addAllCausedByPropertyShape(this.nextRight.getCausedByPropertyShapes());
                                this.next.addHistory(this.nextRight);
                            } else {
                                this.next = TupleHelper.join(this.nextLeft, this.nextRight);
                            }
                            this.nextRight = null;
                            continue;
                        }
                        int compareTo = this.nextLeft.compareTo(this.nextRight);
                        if (compareTo < 0) {
                            if (this.leftIterator.hasNext()) {
                                this.nextLeft = (Tuple)this.leftIterator.next();
                                continue;
                            }
                            this.nextLeft = null;
                            break;
                        }
                        if (this.rightIterator.hasNext()) {
                            this.nextRight = (Tuple)this.rightIterator.next();
                            continue;
                        }
                        this.nextRight = null;
                        break;
                    }
                    return;
                }
            }

            public void close() throws SailException {
                this.leftIterator.close();
                this.rightIterator.close();
            }

            public boolean hasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            public Tuple next() throws SailException {
                this.calculateNext();
                Tuple temp = this.next;
                this.next = null;
                return temp;
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return 0;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        this.left.getPlanAsGraphvizDot(stringBuilder);
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.left.getId() + " -> " + this.getId() + " [label=\"left\"];").append("\n");
        stringBuilder.append(this.right.getId() + " -> " + this.getId() + " [label=\"right\"];").append("\n");
        this.right.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public IteratorData getIteratorDataType() {
        if (this.left.getIteratorDataType() == this.right.getIteratorDataType()) {
            return this.left.getIteratorDataType();
        }
        throw new IllegalStateException("Not implemented support for when left and right have different types of data");
    }

    public String toString() {
        return "EqualsJoin{useAsFilter=" + this.useAsFilter + '}';
    }
}

