/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldValueQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

abstract class SortedNumericDocValuesRangeQuery
extends Query {
    private final String field;
    private final long lowerValue;
    private final long upperValue;

    SortedNumericDocValuesRangeQuery(String field, long lowerValue, long upperValue) {
        this.field = Objects.requireNonNull(field);
        this.lowerValue = lowerValue;
        this.upperValue = upperValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        SortedNumericDocValuesRangeQuery that = (SortedNumericDocValuesRangeQuery)obj;
        return Objects.equals(this.field, that.field) && this.lowerValue == that.lowerValue && this.upperValue == that.upperValue;
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.field.hashCode();
        h = 31 * h + Long.hashCode(this.lowerValue);
        h = 31 * h + Long.hashCode(this.upperValue);
        return h;
    }

    @Override
    public String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.field.equals(field)) {
            b.append(this.field).append(":");
        }
        return b.append("[").append(this.lowerValue).append(" TO ").append(this.upperValue).append("]").toString();
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.lowerValue == Long.MIN_VALUE && this.upperValue == Long.MAX_VALUE) {
            return new FieldValueQuery(this.field);
        }
        return super.rewrite(reader);
    }

    abstract SortedNumericDocValues getValues(LeafReader var1, String var2) throws IOException;

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                TwoPhaseIterator iterator;
                final SortedNumericDocValues values = SortedNumericDocValuesRangeQuery.this.getValues(context.reader(), SortedNumericDocValuesRangeQuery.this.field);
                if (values == null) {
                    return null;
                }
                final NumericDocValues singleton = DocValues.unwrapSingleton(values);
                DocIdSetIterator approximation = DocIdSetIterator.all(context.reader().maxDoc());
                if (singleton != null) {
                    final Bits docsWithField = DocValues.unwrapSingletonBits(values);
                    iterator = new TwoPhaseIterator(approximation){

                        @Override
                        public boolean matches() throws IOException {
                            long value = singleton.get(this.approximation.docID());
                            return (value != 0L || docsWithField == null || docsWithField.get(this.approximation.docID())) && value >= SortedNumericDocValuesRangeQuery.this.lowerValue && value <= SortedNumericDocValuesRangeQuery.this.upperValue;
                        }

                        @Override
                        public float matchCost() {
                            return 2.0f;
                        }
                    };
                } else {
                    iterator = new TwoPhaseIterator(approximation){

                        @Override
                        public boolean matches() throws IOException {
                            values.setDocument(this.approximation.docID());
                            int count = values.count();
                            for (int i = 0; i < count; ++i) {
                                long value = values.valueAt(i);
                                if (value < SortedNumericDocValuesRangeQuery.this.lowerValue) continue;
                                return value <= SortedNumericDocValuesRangeQuery.this.upperValue;
                            }
                            return false;
                        }

                        @Override
                        public float matchCost() {
                            return 2.0f;
                        }
                    };
                }
                return new ConstantScoreScorer((Weight)this, this.score(), iterator);
            }
        };
    }
}

