/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.rio.ntriples.NTriplesUtil;

public class Util {
    public static Resource getContext(Repository repository, String ctxID) {
        if (ctxID.equalsIgnoreCase("null")) {
            return null;
        }
        if (ctxID.startsWith("_:")) {
            return repository.getValueFactory().createBNode(ctxID.substring(2));
        }
        return repository.getValueFactory().createIRI(ctxID);
    }

    public static Resource[] getContexts(String[] tokens, int pos, Repository repository) throws IllegalArgumentException {
        Resource[] contexts = new Resource[]{};
        if (tokens.length > pos) {
            contexts = new Resource[tokens.length - pos];
            for (int i = pos; i < tokens.length; ++i) {
                contexts[i - pos] = Util.getContext(repository, tokens[i]);
            }
        }
        return contexts;
    }

    public static Path getPath(String file) {
        Path path = null;
        try {
            path = Paths.get(file, new String[0]);
        }
        catch (InvalidPathException ipe) {
            try {
                path = Paths.get(new URI(file));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return path;
    }

    public static String getPrefixedValue(Value value, Map<String, String> namespaces) {
        Literal lit;
        IRI uri;
        String prefix;
        IRI uri2;
        String prefix2;
        if (value == null) {
            return null;
        }
        if (namespaces.isEmpty()) {
            return NTriplesUtil.toNTriplesString(value);
        }
        if (value instanceof IRI && (prefix2 = namespaces.get((uri2 = (IRI)value).getNamespace())) != null) {
            return prefix2 + ":" + uri2.getLocalName();
        }
        if (value instanceof Literal && (prefix = namespaces.get((uri = (lit = (Literal)value).getDatatype()).getNamespace())) != null) {
            return "\"" + lit.getLabel() + "\"^^" + prefix + ":" + uri.getLocalName();
        }
        return NTriplesUtil.toNTriplesString(value);
    }

    @Deprecated
    public static String formatToWidth(int width, String padding, String str, String separator) {
        if (str.isEmpty()) {
            return "";
        }
        int padLen = padding.length();
        int strLen = str.length();
        int sepLen = separator.length();
        if (strLen + padLen <= width) {
            return padding + str;
        }
        String[] values = str.split(separator);
        StringBuilder builder = new StringBuilder(strLen + 4 * padLen + 8 * sepLen);
        int colpos = width;
        for (String value : values) {
            int len = value.length();
            if (colpos + sepLen + len <= width) {
                builder.append(separator);
            } else {
                builder.append("\n").append(padding);
                colpos = padLen;
            }
            builder.append(value);
            colpos += len;
        }
        return builder.substring(1);
    }
}

