/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.iterator;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;

public class ConsumingIteration
implements CloseableIteration<BindingSet, QueryEvaluationException> {
    private static final int max = 1000;
    private final List<BindingSet> consumed = Lists.newArrayList();
    private final CloseableIteration<BindingSet, QueryEvaluationException> innerIter;
    private int currentIndex = 0;

    public ConsumingIteration(CloseableIteration<BindingSet, QueryEvaluationException> iter) throws QueryEvaluationException {
        this.innerIter = iter;
        while (this.consumed.size() < 1000 && iter.hasNext()) {
            this.consumed.add((BindingSet)iter.next());
        }
        if (!iter.hasNext()) {
            iter.close();
        }
    }

    @Override
    public boolean hasNext() throws QueryEvaluationException {
        return this.currentIndex < this.consumed.size() || this.innerIter.hasNext();
    }

    @Override
    public BindingSet next() throws QueryEvaluationException {
        if (this.hasNext()) {
            if (this.currentIndex < this.consumed.size()) {
                BindingSet result = this.consumed.get(this.currentIndex);
                ++this.currentIndex;
                return result;
            }
            return (BindingSet)this.innerIter.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() throws QueryEvaluationException {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public void close() throws QueryEvaluationException {
        Iterations.closeCloseable(this.innerIter);
    }
}

