/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.GlobalValidationExecutionLogging;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.ValidationExecutionLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedSplitter
implements PlanNodeProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    PlanNode parent;
    private List<Tuple> tuplesBuffer;

    public BufferedSplitter(PlanNode planNode) {
        this.parent = planNode;
    }

    private synchronized void init() {
        if (this.tuplesBuffer == null) {
            this.tuplesBuffer = new ArrayList<Tuple>();
            try (CloseableIteration<Tuple, SailException> iterator = this.parent.iterator();){
                while (iterator.hasNext()) {
                    Tuple next = (Tuple)iterator.next();
                    this.tuplesBuffer.add(next);
                }
            }
        }
    }

    @Override
    public PlanNode getPlanNode() {
        return new PlanNode(){
            private boolean printed = false;
            private ValidationExecutionLogger validationExecutionLogger;

            @Override
            public CloseableIteration<Tuple, SailException> iterator() {
                BufferedSplitter.this.init();
                final Iterator iterator = BufferedSplitter.this.tuplesBuffer.iterator();
                return new CloseableIteration<Tuple, SailException>(){

                    @Override
                    public void close() throws SailException {
                    }

                    @Override
                    public boolean hasNext() throws SailException {
                        return iterator.hasNext();
                    }

                    @Override
                    public Tuple next() throws SailException {
                        Tuple tuple = new Tuple((Tuple)iterator.next());
                        if (GlobalValidationExecutionLogging.loggingEnabled) {
                            validationExecutionLogger.log(this.depth(), BufferedSplitter.this.parent.getClass().getSimpleName() + ":BufferedSplitter.next()", tuple, BufferedSplitter.this.parent, this.getId());
                        }
                        return tuple;
                    }

                    @Override
                    public void remove() throws SailException {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int depth() {
                return BufferedSplitter.this.parent.depth() + 1;
            }

            @Override
            public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
                if (this.printed) {
                    return;
                }
                this.printed = true;
                stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
                stringBuilder.append(BufferedSplitter.this.parent.getId() + " -> " + this.getId()).append("\n");
                BufferedSplitter.this.parent.getPlanAsGraphvizDot(stringBuilder);
            }

            @Override
            public String getId() {
                return System.identityHashCode(BufferedSplitter.this) + "";
            }

            @Override
            public IteratorData getIteratorDataType() {
                return BufferedSplitter.this.parent.getIteratorDataType();
            }

            public String toString() {
                return "BufferedSplitter";
            }

            @Override
            public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
                this.validationExecutionLogger = validationExecutionLogger;
                BufferedSplitter.this.parent.receiveLogger(validationExecutionLogger);
            }
        };
    }
}

