/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.resultio.QueryResultWriter;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.ValueMappingBindingSet;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.RDFStarUtil;

public abstract class AbstractQueryResultWriter
implements QueryResultWriter {
    private WriterConfig writerConfig = new WriterConfig();
    private final OutputStream outputStream;
    private boolean encodeRDFStar;

    protected AbstractQueryResultWriter() {
        this(null);
    }

    protected AbstractQueryResultWriter(OutputStream out) {
        this.outputStream = out;
    }

    @Override
    public Optional<OutputStream> getOutputStream() {
        return Optional.ofNullable(this.outputStream);
    }

    @Override
    public void setWriterConfig(WriterConfig config) {
        this.writerConfig = config;
    }

    @Override
    public WriterConfig getWriterConfig() {
        return this.writerConfig;
    }

    @Override
    public Collection<RioSetting<?>> getSupportedSettings() {
        return Collections.emptyList();
    }

    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        this.encodeRDFStar = this instanceof TupleQueryResultWriter && !((TupleQueryResultWriter)((Object)this)).getTupleQueryResultFormat().supportsRDFStar() && (Boolean)this.getWriterConfig().get(BasicWriterSettings.ENCODE_RDF_STAR) != false;
    }

    public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        if (this.encodeRDFStar) {
            this.handleSolutionImpl((BindingSet)new ValueMappingBindingSet(bindingSet, RDFStarUtil::toRDFEncodedValue));
        } else {
            this.handleSolutionImpl(bindingSet);
        }
    }

    protected void handleSolutionImpl(BindingSet bindings) throws TupleQueryResultHandlerException {
        throw new UnsupportedOperationException();
    }

    protected boolean xsdStringToPlainLiteral() {
        return (Boolean)this.getWriterConfig().get(BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL);
    }
}

