/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail;

import org.eclipse.rdf4j.sail.LockManager;
import org.eclipse.rdf4j.sail.SailException;

public class SailLockedException
extends SailException {
    private static final long serialVersionUID = -2465202131214972460L;
    private String lockedBy;
    private String requestedBy;
    private LockManager manager;

    public SailLockedException(String requestedBy) {
        super("SAIL could not be locked (check permissions)");
        this.requestedBy = requestedBy;
    }

    public SailLockedException(String lockedBy, String requestedBy) {
        super("SAIL is already locked by: " + lockedBy);
        this.lockedBy = lockedBy;
        this.requestedBy = requestedBy;
    }

    public SailLockedException(String lockedBy, String requestedBy, LockManager manager) {
        super("SAIL is already locked by: " + lockedBy + " in " + manager.getLocation());
        this.lockedBy = lockedBy;
        this.requestedBy = requestedBy;
        this.manager = manager;
    }

    public String getLockedBy() {
        return this.lockedBy;
    }

    public String getRequestedBy() {
        return this.requestedBy;
    }

    public LockManager getLockManager() {
        return this.manager;
    }
}

