/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.text;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.BooleanQueryResultHandlerException;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.resultio.AbstractQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultWriter;

public class BooleanTextWriter
extends AbstractQueryResultWriter
implements BooleanQueryResultWriter {
    private Writer writer;

    public BooleanTextWriter(OutputStream out) {
        this.writer = new OutputStreamWriter(out, StandardCharsets.US_ASCII);
    }

    public final BooleanQueryResultFormat getBooleanQueryResultFormat() {
        return BooleanQueryResultFormat.TEXT;
    }

    public final BooleanQueryResultFormat getQueryResultFormat() {
        return this.getBooleanQueryResultFormat();
    }

    public void write(boolean value) throws IOException {
        try {
            this.handleBoolean(value);
        }
        catch (QueryResultHandlerException e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    public void handleBoolean(boolean value) throws QueryResultHandlerException {
        try {
            this.writer.write(Boolean.toString(value));
            this.writer.flush();
        }
        catch (IOException e) {
            throw new BooleanQueryResultHandlerException((Throwable)e);
        }
    }

    public void startDocument() throws QueryResultHandlerException {
    }

    public void handleStylesheet(String stylesheetUrl) throws QueryResultHandlerException {
    }

    public void startHeader() throws QueryResultHandlerException {
    }

    public void handleLinks(List<String> linkUrls) throws QueryResultHandlerException {
    }

    public void endHeader() throws QueryResultHandlerException {
    }

    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        throw new UnsupportedOperationException("Cannot handle tuple results");
    }

    public void endQueryResult() throws TupleQueryResultHandlerException {
        throw new UnsupportedOperationException("Cannot handle tuple results");
    }

    protected void handleSolutionImpl(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        throw new UnsupportedOperationException("Cannot handle tuple results");
    }

    public void handleNamespace(String prefix, String uri) throws QueryResultHandlerException {
    }
}

