/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdUtils;
import com.github.jsonldjava.core.RemoteDocument;
import com.github.jsonldjava.utils.JsonLdUrl;
import com.github.jsonldjava.utils.Obj;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Context
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 2894534897574805571L;
    private JsonLdOptions options;
    private Map<String, Object> termDefinitions;
    public Map<String, Object> inverse = null;

    public Context() {
        this(new JsonLdOptions());
    }

    public Context(JsonLdOptions opts) {
        this.init(opts);
    }

    public Context(Map<String, Object> map, JsonLdOptions opts) {
        super(map);
        this.checkEmptyKey(map);
        this.init(opts);
    }

    public Context(Map<String, Object> map) {
        super(map);
        this.checkEmptyKey(map);
        this.init(new JsonLdOptions());
    }

    public Context(Object context, JsonLdOptions opts) {
        super(context instanceof Map ? (Map)context : null);
        this.init(opts);
    }

    private void init(JsonLdOptions options) {
        this.options = options;
        if (options.getBase() != null) {
            this.put("@base", options.getBase());
        }
        this.termDefinitions = Obj.newMap();
    }

    public Object compactValue(String activeProperty, Map<String, Object> value) {
        int numberMembers = value.size();
        if (value.containsKey("@index") && "@index".equals(this.getContainer(activeProperty))) {
            --numberMembers;
        }
        if (numberMembers > 2) {
            return value;
        }
        String typeMapping = this.getTypeMapping(activeProperty);
        String languageMapping = this.getLanguageMapping(activeProperty);
        if (value.containsKey("@id")) {
            if (numberMembers == 1 && "@id".equals(typeMapping)) {
                return this.compactIri((String)value.get("@id"));
            }
            if (numberMembers == 1 && "@vocab".equals(typeMapping)) {
                return this.compactIri((String)value.get("@id"), true);
            }
            return value;
        }
        Object valueValue = value.get("@value");
        if (value.containsKey("@type") && Obj.equals(value.get("@type"), typeMapping)) {
            return valueValue;
        }
        if (value.containsKey("@language") && (Obj.equals(value.get("@language"), languageMapping) || Obj.equals(value.get("@language"), this.get("@language")))) {
            return valueValue;
        }
        if (numberMembers == 1 && (!(valueValue instanceof String) || !this.containsKey("@language") || this.termDefinitions.containsKey(activeProperty) && this.getTermDefinition(activeProperty).containsKey("@language") && languageMapping == null)) {
            return valueValue;
        }
        return value;
    }

    public Context parse(Object localContext, List<String> remoteContexts) throws JsonLdError {
        return this.parse(localContext, remoteContexts, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Context parse(Object localContext, List<String> remoteContexts, boolean parsingARemoteContext) throws JsonLdError {
        if (remoteContexts == null) {
            remoteContexts = new ArrayList<String>();
        }
        Context result = this.clone();
        if (!(localContext instanceof List)) {
            ArrayList temp = localContext;
            localContext = new ArrayList();
            ((List)localContext).add(temp);
        }
        for (Object context : (List)localContext) {
            Object value;
            if (context == null) {
                result = new Context(this.options);
                continue;
            }
            if (context instanceof Context) {
                result = ((Context)context).clone();
            } else {
                if (context instanceof String) {
                    String uri = (String)result.get("@base");
                    if (remoteContexts.contains(uri = JsonLdUrl.resolve(uri, (String)context))) {
                        throw new JsonLdError(JsonLdError.Error.RECURSIVE_CONTEXT_INCLUSION, uri);
                    }
                    remoteContexts.add(uri);
                    RemoteDocument rd = this.options.getDocumentLoader().loadDocument(uri);
                    Object remoteContext = rd.getDocument();
                    if (!(remoteContext instanceof Map) || !((Map)remoteContext).containsKey("@context")) {
                        throw new JsonLdError(JsonLdError.Error.INVALID_REMOTE_CONTEXT, context);
                    }
                    Object tempContext = ((Map)remoteContext).get("@context");
                    result = result.parse(tempContext, remoteContexts, true);
                    continue;
                }
                if (!(context instanceof Map)) {
                    throw new JsonLdError(JsonLdError.Error.INVALID_LOCAL_CONTEXT, context);
                }
            }
            this.checkEmptyKey((Map)context);
            if (!parsingARemoteContext && ((Map)context).containsKey("@base")) {
                value = ((Map)context).get("@base");
                if (value == null) {
                    result.remove("@base");
                } else {
                    if (!(value instanceof String)) throw new JsonLdError(JsonLdError.Error.INVALID_BASE_IRI, "@base must be a string");
                    if (JsonLdUtils.isAbsoluteIri((String)value)) {
                        result.put("@base", value);
                    } else {
                        String baseUri = (String)result.get("@base");
                        if (!JsonLdUtils.isAbsoluteIri(baseUri)) {
                            throw new JsonLdError(JsonLdError.Error.INVALID_BASE_IRI, baseUri);
                        }
                        result.put("@base", JsonLdUrl.resolve(baseUri, (String)value));
                    }
                }
            }
            if (((Map)context).containsKey("@vocab")) {
                value = ((Map)context).get("@vocab");
                if (value == null) {
                    result.remove("@vocab");
                } else {
                    if (!(value instanceof String)) throw new JsonLdError(JsonLdError.Error.INVALID_VOCAB_MAPPING, "@vocab must be a string or null");
                    if (!JsonLdUtils.isAbsoluteIri((String)value)) throw new JsonLdError(JsonLdError.Error.INVALID_VOCAB_MAPPING, "@value must be an absolute IRI");
                    result.put("@vocab", value);
                }
            }
            if (((Map)context).containsKey("@language")) {
                value = ((Map)context).get("@language");
                if (value == null) {
                    result.remove("@language");
                } else {
                    if (!(value instanceof String)) throw new JsonLdError(JsonLdError.Error.INVALID_DEFAULT_LANGUAGE, value);
                    result.put("@language", ((String)value).toLowerCase());
                }
            }
            LinkedHashMap<String, Boolean> defined = new LinkedHashMap<String, Boolean>();
            for (String key : ((Map)context).keySet()) {
                if ("@base".equals(key) || "@vocab".equals(key) || "@language".equals(key)) continue;
                result.createTermDefinition((Map)context, key, defined);
            }
        }
        return result;
    }

    private void checkEmptyKey(Map<String, Object> map) {
        if (map.containsKey("")) {
            throw new JsonLdError(JsonLdError.Error.INVALID_TERM_DEFINITION, String.format("empty key for value '%s'", map.get("")));
        }
    }

    public Context parse(Object localContext) throws JsonLdError {
        return this.parse(localContext, new ArrayList<String>());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createTermDefinition(Map<String, Object> context, String term, Map<String, Boolean> defined) throws JsonLdError {
        if (defined.containsKey(term)) {
            if (!Boolean.TRUE.equals(defined.get(term))) throw new JsonLdError(JsonLdError.Error.CYCLIC_IRI_MAPPING, term);
            return;
        }
        defined.put(term, false);
        if (JsonLdUtils.isKeyword(term) && (!this.options.getAllowContainerSetOnType().booleanValue() || !"@type".equals(term) || context.get(term).toString().contains("@id"))) {
            throw new JsonLdError(JsonLdError.Error.KEYWORD_REDEFINITION, term);
        }
        this.termDefinitions.remove(term);
        Map<String, Object> value = context.get(term);
        if (value == null || value instanceof Map && ((Map)value).containsKey("@id") && ((Map)value).get("@id") == null) {
            this.termDefinitions.put(term, null);
            defined.put(term, true);
            return;
        }
        if (value instanceof String) {
            value = Obj.newMap("@id", value);
        }
        if (!(value instanceof Map)) {
            throw new JsonLdError(JsonLdError.Error.INVALID_TERM_DEFINITION, value);
        }
        Map<String, Object> val = value;
        Map<String, Object> definition = Obj.newMap();
        if (val.containsKey("@type")) {
            if (!(val.get("@type") instanceof String)) {
                throw new JsonLdError(JsonLdError.Error.INVALID_TYPE_MAPPING, val.get("@type"));
            }
            String type = (String)val.get("@type");
            try {
                type = this.expandIri((String)val.get("@type"), false, true, context, defined);
            }
            catch (JsonLdError error) {
                if (error.getType() == JsonLdError.Error.INVALID_IRI_MAPPING) throw new JsonLdError(JsonLdError.Error.INVALID_TYPE_MAPPING, type, error);
                throw error;
            }
            if (!"@id".equals(type) && !"@vocab".equals(type) && (type.startsWith("_:") || !JsonLdUtils.isAbsoluteIri(type))) throw new JsonLdError(JsonLdError.Error.INVALID_TYPE_MAPPING, type);
            definition.put("@type", type);
        }
        if (val.containsKey("@reverse")) {
            if (val.containsKey("@id")) {
                throw new JsonLdError(JsonLdError.Error.INVALID_REVERSE_PROPERTY, val);
            }
            if (!(val.get("@reverse") instanceof String)) {
                throw new JsonLdError(JsonLdError.Error.INVALID_IRI_MAPPING, "Expected String for @reverse value. got " + (val.get("@reverse") == null ? "null" : val.get("@reverse").getClass()));
            }
            String reverse = this.expandIri((String)val.get("@reverse"), false, true, context, defined);
            if (!JsonLdUtils.isAbsoluteIri(reverse)) {
                throw new JsonLdError(JsonLdError.Error.INVALID_IRI_MAPPING, "Non-absolute @reverse IRI: " + reverse);
            }
            definition.put("@id", reverse);
            if (val.containsKey("@container")) {
                String container = (String)val.get("@container");
                if (container != null && !"@set".equals(container) && !"@index".equals(container)) throw new JsonLdError(JsonLdError.Error.INVALID_REVERSE_PROPERTY, "reverse properties only support set- and index-containers");
                definition.put("@container", container);
            }
            definition.put("@reverse", true);
            this.termDefinitions.put(term, definition);
            defined.put(term, true);
            return;
        }
        definition.put("@reverse", false);
        if (val.get("@id") != null && !term.equals(val.get("@id"))) {
            if (!(val.get("@id") instanceof String)) {
                throw new JsonLdError(JsonLdError.Error.INVALID_IRI_MAPPING, "expected value of @id to be a string");
            }
            String res = this.expandIri((String)val.get("@id"), false, true, context, defined);
            if (!JsonLdUtils.isKeyword(res) && !JsonLdUtils.isAbsoluteIri(res)) throw new JsonLdError(JsonLdError.Error.INVALID_IRI_MAPPING, "resulting IRI mapping should be a keyword, absolute IRI or blank node");
            if ("@context".equals(res)) {
                throw new JsonLdError(JsonLdError.Error.INVALID_KEYWORD_ALIAS, "cannot alias @context");
            }
            definition.put("@id", res);
        } else if (term.indexOf(":") >= 0) {
            int colIndex = term.indexOf(":");
            String prefix = term.substring(0, colIndex);
            String suffix = term.substring(colIndex + 1);
            if (context.containsKey(prefix)) {
                this.createTermDefinition(context, prefix, defined);
            }
            if (this.termDefinitions.containsKey(prefix)) {
                definition.put("@id", ((Map)this.termDefinitions.get(prefix)).get("@id") + suffix);
            } else {
                definition.put("@id", term);
            }
        } else if (this.containsKey("@vocab")) {
            definition.put("@id", this.get("@vocab") + term);
        } else if (!"@type".equals(term)) {
            throw new JsonLdError(JsonLdError.Error.INVALID_IRI_MAPPING, "relative term definition without vocab mapping");
        }
        if (val.containsKey("@container")) {
            String container = (String)val.get("@container");
            if (!("@list".equals(container) || "@set".equals(container) || "@index".equals(container) || "@language".equals(container))) {
                throw new JsonLdError(JsonLdError.Error.INVALID_CONTAINER_MAPPING, "@container must be either @list, @set, @index, or @language");
            }
            definition.put("@container", container);
            if ("@type".equals(term)) {
                definition.put("@id", "type");
            }
        }
        if (val.containsKey("@language") && !val.containsKey("@type")) {
            if (val.get("@language") != null && !(val.get("@language") instanceof String)) throw new JsonLdError(JsonLdError.Error.INVALID_LANGUAGE_MAPPING, "@language must be a string or null");
            String language = (String)val.get("@language");
            definition.put("@language", language != null ? language.toLowerCase() : null);
        }
        this.termDefinitions.put(term, definition);
        defined.put(term, true);
    }

    String expandIri(String value, boolean relative, boolean vocab, Map<String, Object> context, Map<String, Boolean> defined) throws JsonLdError {
        if (value == null || JsonLdUtils.isKeyword(value)) {
            return value;
        }
        if (context != null && context.containsKey(value) && !Boolean.TRUE.equals(defined.get(value))) {
            this.createTermDefinition(context, value, defined);
        }
        if (vocab && this.termDefinitions.containsKey(value)) {
            Map td = (Map)this.termDefinitions.get(value);
            if (td != null) {
                return (String)td.get("@id");
            }
            return null;
        }
        int colIndex = value.indexOf(":");
        if (colIndex >= 0) {
            String prefix = value.substring(0, colIndex);
            String suffix = value.substring(colIndex + 1);
            if ("_".equals(prefix) || suffix.startsWith("//")) {
                return value;
            }
            if (!(context == null || !context.containsKey(prefix) || defined.containsKey(prefix) && defined.get(prefix).booleanValue())) {
                this.createTermDefinition(context, prefix, defined);
            }
            if (this.termDefinitions.containsKey(prefix)) {
                return (String)((Map)this.termDefinitions.get(prefix)).get("@id") + suffix;
            }
            return value;
        }
        if (vocab && this.containsKey("@vocab")) {
            return this.get("@vocab") + value;
        }
        if (relative) {
            return JsonLdUrl.resolve((String)this.get("@base"), value);
        }
        if (context != null && JsonLdUtils.isRelativeIri(value)) {
            throw new JsonLdError(JsonLdError.Error.INVALID_IRI_MAPPING, "not an absolute IRI: " + value);
        }
        return value;
    }

    String compactIri(String iri, Object value, boolean relativeToVocab, boolean reverse) {
        String suffix;
        String vocab;
        if (iri == null) {
            return null;
        }
        if (relativeToVocab && this.getInverse().containsKey(iri)) {
            String defaultLanguage = (String)this.get("@language");
            if (defaultLanguage == null) {
                defaultLanguage = "@none";
            }
            ArrayList<String> containers = new ArrayList<String>();
            String typeLanguage = "@language";
            String typeLanguageValue = "@null";
            if (value instanceof Map && ((Map)value).containsKey("@index")) {
                containers.add("@index");
            }
            if (reverse) {
                typeLanguage = "@type";
                typeLanguageValue = "@reverse";
                containers.add("@set");
            } else if (value instanceof Map && ((Map)value).containsKey("@list")) {
                List list;
                if (!((Map)value).containsKey("@index")) {
                    containers.add("@list");
                }
                String commonLanguage = (list = (List)((Map)value).get("@list")).size() == 0 ? defaultLanguage : null;
                String commonType = null;
                for (Object item : list) {
                    String itemLanguage = "@none";
                    String itemType = "@none";
                    if (JsonLdUtils.isValue(item).booleanValue()) {
                        if (((Map)item).containsKey("@language")) {
                            itemLanguage = (String)((Map)item).get("@language");
                        } else if (((Map)item).containsKey("@type")) {
                            itemType = (String)((Map)item).get("@type");
                        } else {
                            itemLanguage = "@null";
                        }
                    } else {
                        itemType = "@id";
                    }
                    if (commonLanguage == null) {
                        commonLanguage = itemLanguage;
                    } else if (!commonLanguage.equals(itemLanguage) && JsonLdUtils.isValue(item).booleanValue()) {
                        commonLanguage = "@none";
                    }
                    if (commonType == null) {
                        commonType = itemType;
                    } else if (!commonType.equals(itemType)) {
                        commonType = "@none";
                    }
                    if (!"@none".equals(commonLanguage) || !"@none".equals(commonType)) continue;
                    break;
                }
                commonLanguage = commonLanguage != null ? commonLanguage : "@none";
                String string = commonType = commonType != null ? commonType : "@none";
                if (!"@none".equals(commonType)) {
                    typeLanguage = "@type";
                    typeLanguageValue = commonType;
                } else {
                    typeLanguageValue = commonLanguage;
                }
            } else {
                if (value instanceof Map && ((Map)value).containsKey("@value")) {
                    if (((Map)value).containsKey("@language") && !((Map)value).containsKey("@index")) {
                        containers.add("@language");
                        typeLanguageValue = (String)((Map)value).get("@language");
                    } else if (((Map)value).containsKey("@type")) {
                        typeLanguage = "@type";
                        typeLanguageValue = (String)((Map)value).get("@type");
                    }
                } else {
                    typeLanguage = "@type";
                    typeLanguageValue = "@id";
                }
                containers.add("@set");
            }
            containers.add("@none");
            if (typeLanguageValue == null) {
                typeLanguageValue = "@null";
            }
            ArrayList<String> preferredValues = new ArrayList<String>();
            if ("@reverse".equals(typeLanguageValue)) {
                preferredValues.add("@reverse");
            }
            if (("@reverse".equals(typeLanguageValue) || "@id".equals(typeLanguageValue)) && value instanceof Map && ((Map)value).containsKey("@id")) {
                String result = this.compactIri((String)((Map)value).get("@id"), null, true, true);
                if (this.termDefinitions.containsKey(result) && ((Map)this.termDefinitions.get(result)).containsKey("@id") && ((Map)value).get("@id").equals(((Map)this.termDefinitions.get(result)).get("@id"))) {
                    preferredValues.add("@vocab");
                    preferredValues.add("@id");
                } else {
                    preferredValues.add("@id");
                    preferredValues.add("@vocab");
                }
            } else {
                preferredValues.add(typeLanguageValue);
            }
            preferredValues.add("@none");
            String term = this.selectTerm(iri, containers, typeLanguage, preferredValues);
            if (term != null) {
                return term;
            }
        }
        if (relativeToVocab && this.containsKey("@vocab") && iri.indexOf(vocab = (String)this.get("@vocab")) == 0 && !iri.equals(vocab) && !this.termDefinitions.containsKey(suffix = iri.substring(vocab.length()))) {
            return suffix;
        }
        String compactIRI = null;
        for (String term : this.termDefinitions.keySet()) {
            Map termDefinition = (Map)this.termDefinitions.get(term);
            if (term.contains(":") || termDefinition == null || iri.equals(termDefinition.get("@id")) || !iri.startsWith((String)termDefinition.get("@id"))) continue;
            String candidate = term + ":" + iri.substring(((String)termDefinition.get("@id")).length());
            compactIRI = Context._iriCompactionStep5point4(iri, value, compactIRI, candidate, this.termDefinitions);
        }
        if (compactIRI != null) {
            return compactIRI;
        }
        if (!relativeToVocab) {
            return JsonLdUrl.removeBase(this.get("@base"), iri);
        }
        return iri;
    }

    public static String _iriCompactionStep5point4(String iri, Object value, String compactIRI, String candidate, Map<String, Object> termDefinitions) {
        boolean condition2;
        boolean condition1 = compactIRI == null || JsonLdUtils.compareShortestLeast(candidate, compactIRI) < 0;
        boolean bl = condition2 = !termDefinitions.containsKey(candidate) || iri.equals(((Map)termDefinitions.get(candidate)).get("@id")) && value == null;
        if (condition1 && condition2) {
            compactIRI = candidate;
        }
        return compactIRI;
    }

    public Map<String, String> getPrefixes(boolean onlyCommonPrefixes) {
        LinkedHashMap<String, String> prefixes = new LinkedHashMap<String, String>();
        for (String term : this.termDefinitions.keySet()) {
            String id;
            Map termDefinition;
            if (term.contains(":") || (termDefinition = (Map)this.termDefinitions.get(term)) == null || (id = (String)termDefinition.get("@id")) == null || term.startsWith("@") || id.startsWith("@") || onlyCommonPrefixes && !id.endsWith("/") && !id.endsWith("#")) continue;
            prefixes.put(term, id);
        }
        return prefixes;
    }

    String compactIri(String iri, boolean relativeToVocab) {
        return this.compactIri(iri, null, relativeToVocab, false);
    }

    String compactIri(String iri) {
        return this.compactIri(iri, null, false, false);
    }

    @Override
    public Context clone() {
        Context rval = (Context)super.clone();
        rval.termDefinitions = new LinkedHashMap<String, Object>(this.termDefinitions);
        return rval;
    }

    public Map<String, Object> getInverse() {
        if (this.inverse != null) {
            return this.inverse;
        }
        this.inverse = Obj.newMap();
        String defaultLanguage = (String)this.get("@language");
        if (defaultLanguage == null) {
            defaultLanguage = "@none";
        }
        ArrayList<String> terms = new ArrayList<String>(this.termDefinitions.keySet());
        Collections.sort(terms, new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                return JsonLdUtils.compareShortestLeast(a, b);
            }
        });
        for (String term : terms) {
            Map typeMap;
            Map languageMap;
            Map typeMap2;
            Map<String, Object> typeLanguageMap;
            String iri;
            Map<String, Object> containerMap;
            Map definition = (Map)this.termDefinitions.get(term);
            if (definition == null) continue;
            String container = (String)definition.get("@container");
            if (container == null) {
                container = "@none";
            }
            if ((containerMap = (Map<String, Object>)this.inverse.get(iri = (String)definition.get("@id"))) == null) {
                containerMap = Obj.newMap();
                this.inverse.put(iri, containerMap);
            }
            if ((typeLanguageMap = (Map<String, Object>)containerMap.get(container)) == null) {
                typeLanguageMap = Obj.newMap();
                typeLanguageMap.put("@language", Obj.newMap());
                typeLanguageMap.put("@type", Obj.newMap());
                containerMap.put(container, typeLanguageMap);
            }
            if (Boolean.TRUE.equals(definition.get("@reverse"))) {
                typeMap2 = (Map)typeLanguageMap.get("@type");
                if (typeMap2.containsKey("@reverse")) continue;
                typeMap2.put("@reverse", term);
                continue;
            }
            if (definition.containsKey("@type")) {
                typeMap2 = (Map)typeLanguageMap.get("@type");
                if (typeMap2.containsKey(definition.get("@type"))) continue;
                typeMap2.put((String)definition.get("@type"), term);
                continue;
            }
            if (definition.containsKey("@language")) {
                languageMap = (Map)typeLanguageMap.get("@language");
                String language = (String)definition.get("@language");
                if (language == null) {
                    language = "@null";
                }
                if (languageMap.containsKey(language)) continue;
                languageMap.put(language, term);
                continue;
            }
            languageMap = (Map)typeLanguageMap.get("@language");
            if (!languageMap.containsKey("@language")) {
                languageMap.put("@language", term);
            }
            if (!languageMap.containsKey("@none")) {
                languageMap.put("@none", term);
            }
            if ((typeMap = (Map)typeLanguageMap.get("@type")).containsKey("@none")) continue;
            typeMap.put("@none", term);
        }
        return this.inverse;
    }

    private String selectTerm(String iri, List<String> containers, String typeLanguage, List<String> preferredValues) {
        Map<String, Object> inv = this.getInverse();
        Map containerMap = (Map)inv.get(iri);
        for (String container : containers) {
            if (!containerMap.containsKey(container)) continue;
            Map typeLanguageMap = (Map)containerMap.get(container);
            Map valueMap = (Map)typeLanguageMap.get(typeLanguage);
            for (String item : preferredValues) {
                if (!valueMap.containsKey(item)) continue;
                return (String)valueMap.get(item);
            }
        }
        return null;
    }

    public String getContainer(String property) {
        if (property == null) {
            return null;
        }
        if ("@graph".equals(property)) {
            return "@set";
        }
        if (!property.equals("@type") && JsonLdUtils.isKeyword(property)) {
            return property;
        }
        Map td = (Map)this.termDefinitions.get(property);
        if (td == null) {
            return null;
        }
        return (String)td.get("@container");
    }

    public Boolean isReverseProperty(String property) {
        Map td = (Map)this.termDefinitions.get(property);
        if (td == null) {
            return false;
        }
        Object reverse = td.get("@reverse");
        return reverse != null && (Boolean)reverse != false;
    }

    public String getTypeMapping(String property) {
        Map td = (Map)this.termDefinitions.get(property);
        if (td == null) {
            return null;
        }
        return (String)td.get("@type");
    }

    public String getLanguageMapping(String property) {
        Map td = (Map)this.termDefinitions.get(property);
        if (td == null) {
            return null;
        }
        return (String)td.get("@language");
    }

    Map<String, Object> getTermDefinition(String key) {
        return (Map)this.termDefinitions.get(key);
    }

    public Object expandValue(String activeProperty, Object value) throws JsonLdError {
        Map<String, Object> rval = Obj.newMap();
        Map<String, Object> td = this.getTermDefinition(activeProperty);
        if (td != null && "@id".equals(td.get("@type"))) {
            rval.put("@id", this.expandIri(value.toString(), true, false, null, null));
            return rval;
        }
        if (td != null && "@vocab".equals(td.get("@type"))) {
            rval.put("@id", this.expandIri(value.toString(), true, true, null, null));
            return rval;
        }
        rval.put("@value", value);
        if (td != null && td.containsKey("@type")) {
            rval.put("@type", td.get("@type"));
        } else if (value instanceof String) {
            if (td != null && td.containsKey("@language")) {
                String lang = (String)td.get("@language");
                if (lang != null) {
                    rval.put("@language", lang);
                }
            } else if (this.get("@language") != null) {
                rval.put("@language", this.get("@language"));
            }
        }
        return rval;
    }

    public Map<String, Object> serialize() {
        Map<String, Object> ctx = Obj.newMap();
        if (this.get("@base") != null && !this.get("@base").equals(this.options.getBase())) {
            ctx.put("@base", this.get("@base"));
        }
        if (this.get("@language") != null) {
            ctx.put("@language", this.get("@language"));
        }
        if (this.get("@vocab") != null) {
            ctx.put("@vocab", this.get("@vocab"));
        }
        for (String term : this.termDefinitions.keySet()) {
            String typeMapping;
            Map definition = (Map)this.termDefinitions.get(term);
            if (definition.get("@language") == null && definition.get("@container") == null && definition.get("@type") == null && (definition.get("@reverse") == null || Boolean.FALSE.equals(definition.get("@reverse")))) {
                String cid = this.compactIri((String)definition.get("@id"));
                ctx.put(term, term.equals(cid) ? definition.get("@id") : cid);
                continue;
            }
            Map<String, Object> defn = Obj.newMap();
            String cid = this.compactIri((String)definition.get("@id"));
            Boolean reverseProperty = Boolean.TRUE.equals(definition.get("@reverse"));
            if (!term.equals(cid) || reverseProperty.booleanValue()) {
                defn.put(reverseProperty != false ? "@reverse" : "@id", cid);
            }
            if ((typeMapping = (String)definition.get("@type")) != null) {
                defn.put("@type", JsonLdUtils.isKeyword(typeMapping) ? typeMapping : this.compactIri(typeMapping, true));
            }
            if (definition.get("@container") != null) {
                defn.put("@container", definition.get("@container"));
            }
            Object lang = definition.get("@language");
            if (definition.get("@language") != null) {
                defn.put("@language", Boolean.FALSE.equals(lang) ? null : (Object)lang);
            }
            ctx.put(term, defn);
        }
        Map<String, Object> rval = Obj.newMap();
        if (ctx != null && !ctx.isEmpty()) {
            rval.put("@context", ctx);
        }
        return rval;
    }
}

