/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.results.lazy;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.IteratorCloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.AST.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.results.ValidationResult;

@Deprecated
@InternalUseOnly
public class ValidationResultIterator
implements Iterator<ValidationResult> {
    private final long limit;
    private long counter = 0L;
    private boolean conforms = true;
    private boolean truncated = false;
    private ValidationResult next = null;
    private CloseableIteration<Tuple, SailException> tupleIterator;

    public ValidationResultIterator(CloseableIteration<Tuple, SailException> tupleIterator, long limit) {
        this.limit = limit;
        this.tupleIterator = tupleIterator;
        this.getTuples();
    }

    private void calculateNext() {
        if (this.tupleIterator.hasNext()) {
            this.conforms = false;
        }
        if (this.next == null && this.tupleIterator.hasNext()) {
            if (this.limit < 0L || this.counter < this.limit) {
                Tuple invalidTuple = (Tuple)this.tupleIterator.next();
                ValidationResult parent = null;
                ArrayDeque<PropertyShape> propertyShapes = new ArrayDeque<PropertyShape>(invalidTuple.getCausedByPropertyShapes());
                while (!propertyShapes.isEmpty()) {
                    ValidationResult validationResult = new ValidationResult(propertyShapes.pop(), invalidTuple.getLine().get(0), invalidTuple.getLine().get(invalidTuple.getLine().size() - 1));
                    if (parent == null) {
                        this.next = validationResult;
                    } else {
                        parent.setDetail(validationResult);
                    }
                    parent = validationResult;
                }
                ++this.counter;
            }
            if (this.limit >= 0L && this.counter >= this.limit && this.tupleIterator.hasNext()) {
                this.truncated = true;
            }
        }
    }

    public List<Tuple> getTuples() {
        ArrayList actualList = new ArrayList();
        long localCounter = 0L;
        while (this.tupleIterator.hasNext() && (this.limit < 0L || localCounter++ < this.limit + 1L)) {
            actualList.add(this.tupleIterator.next());
        }
        this.tupleIterator = new IteratorCloseableIteration<Tuple, SailException>(actualList.iterator());
        return Collections.unmodifiableList(actualList);
    }

    public boolean conforms() {
        this.calculateNext();
        return this.conforms;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    @Override
    public boolean hasNext() {
        this.calculateNext();
        return this.next != null;
    }

    @Override
    public ValidationResult next() {
        this.calculateNext();
        if (this.next == null) {
            throw new IllegalStateException();
        }
        ValidationResult temp = this.next;
        this.next = null;
        return temp;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

