/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio.sparqlxml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.common.io.CharSink;
import org.eclipse.rdf4j.common.xml.XMLWriter;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.resultio.AbstractQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.BasicQueryWriterSettings;
import org.eclipse.rdf4j.query.resultio.QueryResultWriter;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.XMLWriterSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractSPARQLXMLWriter
extends AbstractQueryResultWriter
implements QueryResultWriter,
CharSink {
    protected XMLWriter xmlWriter;
    protected boolean documentOpen = false;
    protected boolean headerOpen = false;
    protected boolean headerComplete = false;
    protected boolean tupleVariablesFound = false;
    private Map<String, String> namespaceTable = new HashMap<String, String>();
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected AbstractSPARQLXMLWriter(OutputStream out) {
        this.xmlWriter = new XMLWriter(out);
        this.xmlWriter.setPrettyPrint(true);
    }

    protected AbstractSPARQLXMLWriter(Writer writer) {
        this(new XMLWriter(writer));
    }

    protected AbstractSPARQLXMLWriter(XMLWriter xmlWriter) {
        this.xmlWriter = xmlWriter;
        this.xmlWriter.setPrettyPrint(true);
    }

    public Writer getWriter() {
        return this.xmlWriter.getWriter();
    }

    @Deprecated
    public void setPrettyPrint(boolean prettyPrint) {
        this.getWriterConfig().set(BasicWriterSettings.PRETTY_PRINT, (Object)prettyPrint);
        this.xmlWriter.setPrettyPrint(prettyPrint);
    }

    protected void endDocument() throws IOException {
        this.xmlWriter.endTag("sparql");
        this.xmlWriter.endDocument();
        this.tupleVariablesFound = false;
        this.headerOpen = false;
        this.headerComplete = false;
        this.documentOpen = false;
    }

    public void handleBoolean(boolean value) throws QueryResultHandlerException {
        if (!this.documentOpen) {
            this.startDocument();
        }
        if (!this.headerOpen) {
            this.startHeader();
        }
        if (!this.headerComplete) {
            this.endHeader();
        }
        if (this.tupleVariablesFound) {
            throw new QueryResultHandlerException("Cannot call handleBoolean after startQueryResults");
        }
        try {
            if (value) {
                this.xmlWriter.textElement("boolean", "true");
            } else {
                this.xmlWriter.textElement("boolean", "false");
            }
            this.endDocument();
        }
        catch (IOException e) {
            throw new QueryResultHandlerException((Throwable)e);
        }
    }

    public void startDocument() throws QueryResultHandlerException {
        if (!this.documentOpen) {
            this.documentOpen = true;
            this.headerOpen = false;
            this.headerComplete = false;
            this.tupleVariablesFound = false;
            try {
                this.xmlWriter.setPrettyPrint(((Boolean)this.getWriterConfig().get(BasicWriterSettings.PRETTY_PRINT)).booleanValue());
                if (((Boolean)this.getWriterConfig().get(XMLWriterSettings.INCLUDE_XML_PI)).booleanValue()) {
                    this.xmlWriter.startDocument();
                }
                this.xmlWriter.setAttribute("xmlns", "http://www.w3.org/2005/sparql-results#");
                if (((Boolean)this.getWriterConfig().get(BasicQueryWriterSettings.ADD_SESAME_QNAME)).booleanValue()) {
                    this.xmlWriter.setAttribute("xmlns:q", "http://www.openrdf.org/schema/qname#");
                }
                for (String nextPrefix : this.namespaceTable.keySet()) {
                    this.log.debug("Adding custom prefix for <{}> to map to <{}>", (Object)nextPrefix, (Object)this.namespaceTable.get(nextPrefix));
                    this.xmlWriter.setAttribute("xmlns:" + this.namespaceTable.get(nextPrefix), nextPrefix);
                }
            }
            catch (IOException e) {
                throw new QueryResultHandlerException((Throwable)e);
            }
        }
    }

    public void handleStylesheet(String url) throws QueryResultHandlerException {
        if (!this.documentOpen) {
            this.startDocument();
        }
        try {
            this.xmlWriter.writeStylesheet(url);
        }
        catch (IOException e) {
            throw new QueryResultHandlerException((Throwable)e);
        }
    }

    public void startHeader() throws QueryResultHandlerException {
        if (!this.documentOpen) {
            this.startDocument();
        }
        if (!this.headerOpen) {
            try {
                this.xmlWriter.startTag("sparql");
                this.xmlWriter.startTag("head");
                this.headerOpen = true;
            }
            catch (IOException e) {
                throw new QueryResultHandlerException((Throwable)e);
            }
        }
    }

    public void handleLinks(List<String> linkUrls) throws QueryResultHandlerException {
        if (!this.documentOpen) {
            this.startDocument();
        }
        if (!this.headerOpen) {
            this.startHeader();
        }
        try {
            for (String name : linkUrls) {
                this.xmlWriter.setAttribute("href", name);
                this.xmlWriter.emptyElement("link");
            }
        }
        catch (IOException e) {
            throw new QueryResultHandlerException((Throwable)e);
        }
    }

    public void endHeader() throws QueryResultHandlerException {
        if (!this.documentOpen) {
            this.startDocument();
        }
        if (!this.headerOpen) {
            this.startHeader();
        }
        if (!this.headerComplete) {
            try {
                this.xmlWriter.endTag("head");
                if (this.tupleVariablesFound) {
                    this.xmlWriter.startTag("results");
                }
                this.headerComplete = true;
            }
            catch (IOException e) {
                throw new QueryResultHandlerException((Throwable)e);
            }
        }
    }

    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        super.startQueryResult(bindingNames);
        try {
            if (!this.documentOpen) {
                this.startDocument();
            }
            if (!this.headerOpen) {
                this.startHeader();
            }
            this.tupleVariablesFound = true;
            for (String name : bindingNames) {
                this.xmlWriter.setAttribute("name", name);
                this.xmlWriter.emptyElement("variable");
            }
        }
        catch (IOException | QueryResultHandlerException e) {
            throw new TupleQueryResultHandlerException(e);
        }
    }

    public void endQueryResult() throws TupleQueryResultHandlerException {
        try {
            if (!this.documentOpen) {
                this.startDocument();
            }
            if (!this.headerOpen) {
                this.startHeader();
            }
            if (!this.headerComplete) {
                this.endHeader();
            }
            if (!this.tupleVariablesFound) {
                throw new IllegalStateException("Could not end query result as startQueryResult was not called first.");
            }
            this.xmlWriter.endTag("results");
            this.endDocument();
        }
        catch (IOException | QueryResultHandlerException e) {
            throw new TupleQueryResultHandlerException(e);
        }
    }

    protected void handleSolutionImpl(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        try {
            if (!this.documentOpen) {
                this.startDocument();
            }
            if (!this.headerOpen) {
                this.startHeader();
            }
            if (!this.headerComplete) {
                this.endHeader();
            }
            if (!this.tupleVariablesFound) {
                throw new IllegalStateException("Must call startQueryResult before handleSolution");
            }
            this.xmlWriter.startTag("result");
            for (Binding binding : bindingSet) {
                this.xmlWriter.setAttribute("name", binding.getName());
                this.xmlWriter.startTag("binding");
                this.writeValue(binding.getValue());
                this.xmlWriter.endTag("binding");
            }
            this.xmlWriter.endTag("result");
        }
        catch (IOException | QueryResultHandlerException e) {
            throw new TupleQueryResultHandlerException(e);
        }
    }

    public final Collection<RioSetting<?>> getSupportedSettings() {
        HashSet result = new HashSet(super.getSupportedSettings());
        result.add(BasicWriterSettings.PRETTY_PRINT);
        result.add(BasicQueryWriterSettings.ADD_SESAME_QNAME);
        result.add(BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL);
        return result;
    }

    public void handleNamespace(String prefix, String uri) throws QueryResultHandlerException {
        if (!this.documentOpen) {
            if (!prefix.trim().isEmpty() && !prefix.trim().equals("q")) {
                this.log.debug("Handle namespace: Will map <{}> to <{}>", (Object)uri, (Object)prefix);
                this.namespaceTable.put(uri, prefix);
            } else {
                this.log.debug("handleNamespace was ignored for either the empty prefix or the sesame qname prefix (q). Attempted to map: <{}> to <{}>", (Object)uri, (Object)prefix);
            }
        } else {
            this.log.warn("handleNamespace was ignored after startDocument: <{}> to <{}>", (Object)uri, (Object)prefix);
        }
    }

    private void writeValue(Value value) throws IOException {
        if (value instanceof Triple) {
            this.writeTriple((Triple)value);
        } else if (value instanceof IRI) {
            this.writeURI((IRI)value);
        } else if (value instanceof BNode) {
            this.writeBNode((BNode)value);
        } else if (value instanceof Literal) {
            this.writeLiteral((Literal)value);
        }
    }

    private boolean isQName(IRI nextUri) {
        return this.namespaceTable.containsKey(nextUri.getNamespace());
    }

    private void writeTriple(Triple triple) throws IOException {
        this.xmlWriter.startTag("triple");
        this.xmlWriter.startTag("subject");
        this.writeValue((Value)triple.getSubject());
        this.xmlWriter.endTag("subject");
        this.xmlWriter.startTag("predicate");
        this.writeValue((Value)triple.getPredicate());
        this.xmlWriter.endTag("predicate");
        this.xmlWriter.startTag("object");
        this.writeValue(triple.getObject());
        this.xmlWriter.endTag("object");
        this.xmlWriter.endTag("triple");
    }

    private void writeQName(IRI nextUri) {
        if (((Boolean)this.getWriterConfig().get(BasicQueryWriterSettings.ADD_SESAME_QNAME)).booleanValue()) {
            this.xmlWriter.setAttribute("q:qname", this.namespaceTable.get(nextUri.getNamespace()) + ":" + nextUri.getLocalName());
        }
    }

    private void writeURI(IRI uri) throws IOException {
        if (this.isQName(uri)) {
            this.writeQName(uri);
        }
        this.xmlWriter.textElement("uri", uri.toString());
    }

    private void writeBNode(BNode bNode) throws IOException {
        this.xmlWriter.textElement("bnode", bNode.getID());
    }

    private void writeLiteral(Literal literal) throws IOException {
        if (Literals.isLanguageLiteral((Literal)literal)) {
            this.xmlWriter.setAttribute("xml:lang", (String)literal.getLanguage().get());
        } else {
            boolean ignoreDatatype;
            IRI datatype = literal.getDatatype();
            boolean bl = ignoreDatatype = datatype.equals((Object)XSD.STRING) && this.xsdStringToPlainLiteral();
            if (!ignoreDatatype) {
                if (this.isQName(datatype)) {
                    this.writeQName(datatype);
                }
                this.xmlWriter.setAttribute("datatype", datatype.stringValue());
            }
        }
        this.xmlWriter.textElement("literal", literal.getLabel());
    }
}

