/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.base;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.base.AbstractIRI;

public abstract class AbstractLiteral
implements Literal {
    private static final long serialVersionUID = -1286527360744086451L;
    private static final String RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String XSD = "http://www.w3.org/2001/XMLSchema#";
    private static final IRI RDF_LANGSTRING = new AbstractIRI.GenericIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "langString");
    private static final IRI XSD_STRING = new AbstractIRI.GenericIRI("http://www.w3.org/2001/XMLSchema#", "string");
    private static final IRI XSD_BOOLEAN = new AbstractIRI.GenericIRI("http://www.w3.org/2001/XMLSchema#", "boolean");
    private static final IRI XSD_BYTE = new AbstractIRI.GenericIRI("http://www.w3.org/2001/XMLSchema#", "byte");
    private static final IRI XSD_SHORT = new AbstractIRI.GenericIRI("http://www.w3.org/2001/XMLSchema#", "short");
    private static final IRI XSD_INT = new AbstractIRI.GenericIRI("http://www.w3.org/2001/XMLSchema#", "int");
    private static final IRI XSD_LONG = new AbstractIRI.GenericIRI("http://www.w3.org/2001/XMLSchema#", "long");
    private static final IRI XSD_FLOAT = new AbstractIRI.GenericIRI("http://www.w3.org/2001/XMLSchema#", "float");
    private static final IRI XSD_DOUBLE = new AbstractIRI.GenericIRI("http://www.w3.org/2001/XMLSchema#", "double");
    private static final IRI XSD_INTEGER = new AbstractIRI.GenericIRI("http://www.w3.org/2001/XMLSchema#", "integer");
    private static final IRI XSD_DECIMAL = new AbstractIRI.GenericIRI("http://www.w3.org/2001/XMLSchema#", "decimal");
    private static final IRI XSD_DATETIME = new AbstractIRI.GenericIRI("http://www.w3.org/2001/XMLSchema#", "dateTime");
    private static final IRI XSD_DATE = new AbstractIRI.GenericIRI("http://www.w3.org/2001/XMLSchema#", "date");
    private static final IRI XSD_TIME = new AbstractIRI.GenericIRI("http://www.w3.org/2001/XMLSchema#", "time");
    private static final IRI XSD_GYEARMONTH = new AbstractIRI.GenericIRI("http://www.w3.org/2001/XMLSchema#", "gYearMonth");
    private static final IRI XSD_GMONTHDAY = new AbstractIRI.GenericIRI("http://www.w3.org/2001/XMLSchema#", "gMonthDay");
    private static final IRI XSD_GYEAR = new AbstractIRI.GenericIRI("http://www.w3.org/2001/XMLSchema#", "gYear");
    private static final IRI XSD_GMONTH = new AbstractIRI.GenericIRI("http://www.w3.org/2001/XMLSchema#", "gMonth");
    private static final IRI XSD_GDAY = new AbstractIRI.GenericIRI("http://www.w3.org/2001/XMLSchema#", "gDay");
    private static final IRI XSD_DURATION = new AbstractIRI.GenericIRI("http://www.w3.org/2001/XMLSchema#", "duration");
    private static final IRI XSD_DURATION_DAYTIME = new AbstractIRI.GenericIRI("http://www.w3.org/2001/XMLSchema#", "dayTimeDuration");
    private static final IRI XSD_DURATION_YEARMONTH = new AbstractIRI.GenericIRI("http://www.w3.org/2001/XMLSchema#", "yearMonthDuration");
    private static final String POSITIVE_INFINITY = "INF";
    private static final String NEGATIVE_INFINITY = "-INF";
    private static final String NAN = "NaN";
    private static final ThreadLocal<DatatypeFactory> DATATYPE_FACTORY = ThreadLocal.withInitial(() -> {
        try {
            return DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("unable to create datatype factory", e);
        }
    });

    static boolean reserved(IRI datatype) {
        return RDF_LANGSTRING.equals(datatype);
    }

    protected <V> V value(Function<String, V> mapper) {
        return Optional.of(this.getLabel()).map(Objects.requireNonNull(mapper, "null mapper")).orElseThrow(() -> new IllegalArgumentException("malformed value"));
    }

    @Override
    public String stringValue() {
        return this.getLabel();
    }

    @Override
    public boolean booleanValue() {
        return this.value(label -> Optional.of(label).map(String::trim).map(normalized -> normalized.equals("true") || normalized.equals("1") ? Boolean.TRUE : (normalized.equals("false") || normalized.equals("0") ? Boolean.FALSE : null)).orElse(null));
    }

    @Override
    public byte byteValue() {
        return this.value(Byte::parseByte);
    }

    @Override
    public short shortValue() {
        return this.value(Short::parseShort);
    }

    @Override
    public int intValue() {
        return this.value(Integer::parseInt);
    }

    @Override
    public long longValue() {
        return this.value(Long::parseLong);
    }

    @Override
    public float floatValue() {
        return this.value(label -> Float.valueOf(label.equals(POSITIVE_INFINITY) ? Float.POSITIVE_INFINITY : (label.equals(NEGATIVE_INFINITY) ? Float.NEGATIVE_INFINITY : (label.equals(NAN) ? Float.NaN : Float.parseFloat(label))))).floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value(label -> label.equals(POSITIVE_INFINITY) ? Double.POSITIVE_INFINITY : (label.equals(NEGATIVE_INFINITY) ? Double.NEGATIVE_INFINITY : (label.equals(NAN) ? Double.NaN : Double.parseDouble(label))));
    }

    @Override
    public BigInteger integerValue() {
        return this.value(BigInteger::new);
    }

    @Override
    public BigDecimal decimalValue() {
        return this.value(BigDecimal::new);
    }

    @Override
    public XMLGregorianCalendar calendarValue() {
        return this.value(label -> DATATYPE_FACTORY.get().newXMLGregorianCalendar((String)label));
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o instanceof Literal && this.getLabel().equals(((Literal)o).getLabel()) && this.getDatatype().equals(((Literal)o).getDatatype()) && this.equals(this.getLanguage(), ((Literal)o).getLanguage());
    }

    @Override
    public int hashCode() {
        return this.getLabel().hashCode();
    }

    public String toString() {
        String label = '\"' + this.getLabel() + '\"';
        return this.getLanguage().map(language -> label + '@' + language).orElseGet(() -> {
            IRI datatype = this.getDatatype();
            return datatype.equals(XSD_STRING) ? label : label + "^^<" + datatype.stringValue() + ">";
        });
    }

    private boolean equals(Optional<String> x, Optional<String> y) {
        boolean px = x.isPresent();
        boolean py = y.isPresent();
        return px && py && x.get().equalsIgnoreCase(y.get()) || !px && !py;
    }

    static class CalendarLiteral
    extends AbstractLiteral {
        private static final long serialVersionUID = 9131700079460615839L;
        private static final Map<QName, IRI> DATATYPES = CalendarLiteral.datatypes();
        private XMLGregorianCalendar value;
        private String label;
        private IRI datatype;

        private static Map<QName, IRI> datatypes() {
            HashMap<QName, IRI> datatypes = new HashMap<QName, IRI>();
            datatypes.put(DatatypeConstants.DATETIME, XSD_DATETIME);
            datatypes.put(DatatypeConstants.DATE, XSD_DATE);
            datatypes.put(DatatypeConstants.TIME, XSD_TIME);
            datatypes.put(DatatypeConstants.GYEARMONTH, XSD_GYEARMONTH);
            datatypes.put(DatatypeConstants.GMONTHDAY, XSD_GMONTHDAY);
            datatypes.put(DatatypeConstants.GYEAR, XSD_GYEAR);
            datatypes.put(DatatypeConstants.GMONTH, XSD_GMONTH);
            datatypes.put(DatatypeConstants.GDAY, XSD_GDAY);
            datatypes.put(DatatypeConstants.DURATION, XSD_DURATION);
            datatypes.put(DatatypeConstants.DURATION_DAYTIME, XSD_DURATION_DAYTIME);
            datatypes.put(DatatypeConstants.DURATION_YEARMONTH, XSD_DURATION_YEARMONTH);
            return datatypes;
        }

        private static IRI datatype(QName qname) {
            IRI datatype = DATATYPES.get(qname);
            if (datatype == null) {
                throw new IllegalArgumentException(String.format("QName <%s> cannot be mapped to an XSD datatype IRI", qname));
            }
            return datatype;
        }

        CalendarLiteral(GregorianCalendar calendar) {
            this(((DatatypeFactory)DATATYPE_FACTORY.get()).newXMLGregorianCalendar(calendar));
        }

        CalendarLiteral(XMLGregorianCalendar calendar) {
            this.value = calendar;
            this.label = calendar.toXMLFormat();
            this.datatype = CalendarLiteral.datatype(calendar.getXMLSchemaType());
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public Optional<String> getLanguage() {
            return Optional.empty();
        }

        @Override
        public IRI getDatatype() {
            return this.datatype;
        }

        @Override
        public XMLGregorianCalendar calendarValue() {
            return this.value;
        }
    }

    static class DecimalLiteral
    extends NumberLiteral {
        private static final long serialVersionUID = -4382147098035463886L;

        DecimalLiteral(BigDecimal value) {
            super(value, value.toPlainString(), XSD_DECIMAL);
        }

        @Override
        public BigInteger integerValue() {
            return ((BigDecimal)this.value).toBigInteger();
        }

        @Override
        public BigDecimal decimalValue() {
            return (BigDecimal)this.value;
        }
    }

    static class IntegerLiteral
    extends NumberLiteral {
        private static final long serialVersionUID = -4274941248972496665L;

        IntegerLiteral(BigInteger value) {
            super(value, value.toString(), XSD_INTEGER);
        }

        @Override
        public BigInteger integerValue() {
            return (BigInteger)this.value;
        }

        @Override
        public BigDecimal decimalValue() {
            return new BigDecimal((BigInteger)this.value);
        }
    }

    static class NumberLiteral
    extends AbstractLiteral {
        private static final long serialVersionUID = -3201912818064851702L;
        protected Number value;
        private String label;
        private IRI datatype;

        NumberLiteral(byte value) {
            this(value, Byte.toString(value), XSD_BYTE);
        }

        NumberLiteral(short value) {
            this(value, Short.toString(value), XSD_SHORT);
        }

        NumberLiteral(int value) {
            this(value, Integer.toString(value), XSD_INT);
        }

        NumberLiteral(long value) {
            this(value, Long.toString(value), XSD_LONG);
        }

        NumberLiteral(float value) {
            this(Float.valueOf(value), value == Float.POSITIVE_INFINITY ? AbstractLiteral.POSITIVE_INFINITY : (value == Float.NEGATIVE_INFINITY ? AbstractLiteral.NEGATIVE_INFINITY : (Float.isNaN(value) ? AbstractLiteral.NAN : Float.toString(value))), XSD_FLOAT);
        }

        NumberLiteral(double value) {
            this(value, value == Double.POSITIVE_INFINITY ? AbstractLiteral.POSITIVE_INFINITY : (value == Double.NEGATIVE_INFINITY ? AbstractLiteral.NEGATIVE_INFINITY : (Double.isNaN(value) ? AbstractLiteral.NAN : Double.toString(value))), XSD_DOUBLE);
        }

        NumberLiteral(Number value, String label, IRI datatype) {
            this.value = value;
            this.label = label;
            this.datatype = datatype;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public Optional<String> getLanguage() {
            return Optional.empty();
        }

        @Override
        public IRI getDatatype() {
            return this.datatype;
        }

        @Override
        public byte byteValue() {
            return this.value.byteValue();
        }

        @Override
        public short shortValue() {
            return this.value.shortValue();
        }

        @Override
        public int intValue() {
            return this.value.intValue();
        }

        @Override
        public long longValue() {
            return this.value.longValue();
        }

        @Override
        public float floatValue() {
            return this.value.floatValue();
        }

        @Override
        public double doubleValue() {
            return this.value.doubleValue();
        }
    }

    static class BooleanLiteral
    extends AbstractLiteral {
        private static final long serialVersionUID = -1162147873619834622L;
        private boolean value;

        BooleanLiteral(boolean value) {
            this.value = value;
        }

        @Override
        public String getLabel() {
            return this.value ? "true" : "false";
        }

        @Override
        public Optional<String> getLanguage() {
            return Optional.empty();
        }

        @Override
        public IRI getDatatype() {
            return XSD_BOOLEAN;
        }

        @Override
        public boolean booleanValue() {
            return this.value;
        }
    }

    static class TaggedLiteral
    extends AbstractLiteral {
        private static final long serialVersionUID = -19640527584237291L;
        private String label;
        private String language;

        TaggedLiteral(String label, String language) {
            this.label = label;
            this.language = language;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public Optional<String> getLanguage() {
            return Optional.of(this.language);
        }

        @Override
        public IRI getDatatype() {
            return RDF_LANGSTRING;
        }
    }

    static class TypedLiteral
    extends AbstractLiteral {
        private static final long serialVersionUID = -19640527584237291L;
        private String label;
        private IRI datatype;

        TypedLiteral(String label) {
            this.label = label;
            this.datatype = XSD_STRING;
        }

        TypedLiteral(String label, IRI datatype) {
            this.label = label;
            this.datatype = datatype != null ? datatype : XSD_STRING;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public Optional<String> getLanguage() {
            return Optional.empty();
        }

        @Override
        public IRI getDatatype() {
            return this.datatype;
        }
    }
}

