/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

class LogStatement {
    private final int depth;
    private final String name;
    private final ValidationTuple tuple;
    private final PlanNode planNode;
    private final String id;

    LogStatement(int depth, String name, ValidationTuple tuple, PlanNode planNode, String id) {
        this.depth = depth;
        this.name = name;
        this.tuple = tuple;
        assert (tuple != null);
        this.planNode = planNode;
        this.id = id;
    }

    public int getDepth() {
        return this.depth;
    }

    public String getName() {
        return this.name;
    }

    public ValidationTuple getTuple() {
        return this.tuple;
    }

    public PlanNode getPlanNode() {
        return this.planNode;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return StringUtils.leftPad((String)this.id, (int)14) + "\t" + LogStatement.leadingSpace(this.depth) + this.name + ":  " + this.tuple.toString() + " :  " + this.planNode.toString();
    }

    private static String leadingSpace(int depth) {
        StringBuilder builder = new StringBuilder();
        for (int i = depth; i > 0; --i) {
            builder.append("  ");
        }
        return builder.toString();
    }
}

