/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.rdf;

import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPatterns;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.TriplePattern;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Rdf;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfObject;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfPredicate;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfPredicateObjectList;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfPredicateObjectListCollection;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfResource;
import org.eclipse.rdf4j.sparqlbuilder.util.SparqlBuilderUtils;

public interface RdfBlankNode
extends RdfResource {

    public static class PropertiesBlankNode
    implements RdfBlankNode {
        private RdfPredicateObjectListCollection predicateObjectLists = Rdf.predicateObjectListCollection(new RdfPredicateObjectList[0]);

        PropertiesBlankNode(RdfPredicate predicate, RdfObject ... objects) {
            this.andHas(predicate, objects);
        }

        public PropertiesBlankNode andHas(RdfPredicate predicate, RdfObject ... objects) {
            this.predicateObjectLists.andHas(predicate, objects);
            return this;
        }

        public PropertiesBlankNode andHas(RdfPredicateObjectList ... lists) {
            this.predicateObjectLists.andHas(lists);
            return this;
        }

        public TriplePattern toTp() {
            return GraphPatterns.tp(this);
        }

        @Override
        public String getQueryString() {
            return SparqlBuilderUtils.getBracketedString(this.predicateObjectLists.getQueryString());
        }
    }

    public static class AnonymousBlankNode
    implements RdfBlankNode {
        @Override
        public String getQueryString() {
            return SparqlBuilderUtils.getBracketedString("");
        }
    }

    public static class LabeledBlankNode
    implements RdfBlankNode {
        private String label;

        LabeledBlankNode(String label) {
            this.label = label;
        }

        @Override
        public String getQueryString() {
            return "_:" + this.label;
        }
    }
}

