/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class UnionNode
implements PlanNode {
    private StackTraceElement[] stackTrace;
    private final PlanNode[] nodes;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public UnionNode(PlanNode ... nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = PlanNodeHelper.handleSorting(this, nodes[i]);
        }
        this.nodes = nodes;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            final List<CloseableIteration<? extends ValidationTuple, SailException>> iterators;
            final ValidationTuple[] peekList;
            ValidationTuple next;
            ValidationTuple prev;
            {
                this.iterators = Arrays.stream(UnionNode.this.nodes).map(PlanNode::iterator).collect(Collectors.toList());
                this.peekList = new ValidationTuple[UnionNode.this.nodes.length];
            }

            private void calculateNext() {
                if (this.next != null) {
                    return;
                }
                for (int i = 0; i < this.peekList.length; ++i) {
                    CloseableIteration<? extends ValidationTuple, SailException> iterator;
                    if (this.peekList[i] != null || !(iterator = this.iterators.get(i)).hasNext()) continue;
                    this.peekList[i] = (ValidationTuple)iterator.next();
                }
                ValidationTuple sortedFirst = null;
                int sortedFirstIndex = -1;
                for (int i = 0; i < this.peekList.length; ++i) {
                    if (this.peekList[i] == null) continue;
                    if (sortedFirst == null) {
                        sortedFirst = this.peekList[i];
                        sortedFirstIndex = i;
                        continue;
                    }
                    if (this.peekList[i].compareTarget(sortedFirst) >= 0) continue;
                    sortedFirst = this.peekList[i];
                    sortedFirstIndex = i;
                }
                if (sortedFirstIndex >= 0) {
                    this.peekList[sortedFirstIndex] = null;
                }
                this.next = sortedFirst;
            }

            @Override
            public void close() throws SailException {
                this.iterators.forEach(CloseableIteration::close);
            }

            @Override
            boolean localHasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            ValidationTuple loggingNext() throws SailException {
                this.calculateNext();
                if (this.prev != null && this.next.compareTarget(this.prev) < 0) {
                    throw new AssertionError();
                }
                ValidationTuple temp = this.next;
                this.prev = this.next;
                this.next = null;
                return temp;
            }

            @Override
            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return Arrays.stream(this.nodes).mapToInt(PlanNode::depth).max().orElse(0) + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        for (PlanNode node : this.nodes) {
            stringBuilder.append(node.getId() + " -> " + this.getId()).append("\n");
            node.getPlanAsGraphvizDot(stringBuilder);
        }
    }

    public String toString() {
        return "UnionNode";
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        for (PlanNode node : this.nodes) {
            node.receiveLogger(validationExecutionLogger);
        }
    }

    @Override
    public boolean producesSorted() {
        return true;
    }

    @Override
    public boolean requiresSorted() {
        return true;
    }
}

