/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.function.Function;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.results.ValidationResult;

public class ValidationReportNode
implements PlanNode {
    private final Function<ValidationTuple, ValidationResult> validationResultFunction;
    PlanNode parent;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public ValidationReportNode(PlanNode parent, Function<ValidationTuple, ValidationResult> validationResultFunction) {
        this.parent = parent = PlanNodeHelper.handleSorting(this, parent);
        this.validationResultFunction = validationResultFunction;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            private final CloseableIteration<? extends ValidationTuple, SailException> iterator;
            {
                this.iterator = ValidationReportNode.this.parent.iterator();
            }

            @Override
            public void close() throws SailException {
                this.iterator.close();
            }

            @Override
            public boolean localHasNext() throws SailException {
                return this.iterator.hasNext();
            }

            @Override
            public ValidationTuple loggingNext() throws SailException {
                ValidationTuple next = (ValidationTuple)this.iterator.next();
                return next.addValidationResult(ValidationReportNode.this.validationResultFunction);
            }

            @Override
            public void remove() throws SailException {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId()).append(" [label=\"").append(StringEscapeUtils.escapeJava((String)this.toString())).append("\"];").append("\n");
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    public String toString() {
        return "ValidationReportNode";
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return this.parent.producesSorted();
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }
}

