/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclUnsupportedException;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationApproach;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ComplexQueryFragment;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BulkedExternalInnerJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.InnerJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ShiftToPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleAbstractConstraintComponent
extends AbstractConstraintComponent {
    private static final Logger logger = LoggerFactory.getLogger(SimpleAbstractConstraintComponent.class);
    private Resource id;
    TargetChain targetChain;

    public SimpleAbstractConstraintComponent(Resource id) {
        this.id = id;
    }

    public SimpleAbstractConstraintComponent() {
    }

    @Override
    public Resource getId() {
        return this.id;
    }

    @Override
    public TargetChain getTargetChain() {
        return this.targetChain;
    }

    @Override
    public void setTargetChain(TargetChain targetChain) {
        this.targetChain = targetChain;
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, boolean logValidationPlans, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        return this.generateTransactionalValidationPlan(connectionsGroup, overrideTargetNode, this.getFilterAttacher(), scope);
    }

    @Override
    public PlanNode generateSparqlValidationPlan(ConnectionsGroup connectionsGroup, boolean logValidationPlans, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        String targetVarPrefix = "target_";
        StatementMatcher.Variable value = new StatementMatcher.Variable("value");
        ComplexQueryFragment complexQueryFragment = this.getComplexQueryFragment(targetVarPrefix, value, negatePlan, connectionsGroup);
        String query = complexQueryFragment.getQuery();
        StatementMatcher.Variable targetVar = complexQueryFragment.getTargetVar();
        return new Select(connectionsGroup.getBaseConnection(), query, null, b -> {
            List<String> collect = b.getBindingNames().stream().filter(s -> s.startsWith(targetVarPrefix)).sorted().collect(Collectors.toList());
            ValidationTuple validationTuple = new ValidationTuple((BindingSet)b, collect, scope, true);
            return validationTuple;
        });
    }

    private ComplexQueryFragment getComplexQueryFragment(String targetVarPrefix, StatementMatcher.Variable value, boolean negated, ConnectionsGroup connectionsGroup) {
        EffectiveTarget effectiveTarget = this.targetChain.getEffectiveTarget(targetVarPrefix, ConstraintComponent.Scope.propertyShape, connectionsGroup.getRdfsSubClassOfReasoner());
        String query = effectiveTarget.getQuery(false);
        StatementMatcher.Variable targetVar = effectiveTarget.getTargetVar();
        Optional<String> pathQuery = this.targetChain.getPath().map(p -> p.getTargetQueryFragment(effectiveTarget.getTargetVar(), value, connectionsGroup.getRdfsSubClassOfReasoner()));
        if (pathQuery.isPresent()) {
            query = query + "\n" + pathQuery.get();
            query = query + "\n FILTER(" + this.getSparqlFilterExpression(value.getName(), negated) + ")";
        } else {
            query = query + "\n FILTER(" + this.getSparqlFilterExpression(targetVar.getName(), negated) + ")";
        }
        return new ComplexQueryFragment(query, targetVarPrefix, targetVar, value);
    }

    abstract String getSparqlFilterExpression(String var1, boolean var2);

    PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, PlanNodeProvider overrideTargetNode, Function<PlanNode, FilterPlanNode> filterAttacher, ConstraintComponent.Scope scope) {
        boolean negatePlan = false;
        EffectiveTarget effectiveTarget = this.targetChain.getEffectiveTarget("target_", scope, connectionsGroup.getRdfsSubClassOfReasoner());
        Optional<Path> path = this.targetChain.getPath();
        if (overrideTargetNode != null) {
            PlanNode planNode2;
            if (scope == ConstraintComponent.Scope.nodeShape) {
                planNode2 = overrideTargetNode.getPlanNode();
                planNode2 = effectiveTarget.extend(planNode2, connectionsGroup, scope, EffectiveTarget.Extend.right, false);
            } else {
                PlanNode temp = overrideTargetNode.getPlanNode();
                temp = effectiveTarget.extend(temp, connectionsGroup, scope, EffectiveTarget.Extend.right, false);
                planNode2 = new BulkedExternalInnerJoin(temp, connectionsGroup.getBaseConnection(), path.get().getTargetQueryFragment(new StatementMatcher.Variable("a"), new StatementMatcher.Variable("c"), connectionsGroup.getRdfsSubClassOfReasoner()), false, null, b -> new ValidationTuple(b.getValue("a"), b.getValue("c"), scope, true));
            }
            if (negatePlan) {
                return filterAttacher.apply(planNode2).getTrueNode(UnBufferedPlanNode.class);
            }
            return filterAttacher.apply(planNode2).getFalseNode(UnBufferedPlanNode.class);
        }
        if (scope == ConstraintComponent.Scope.nodeShape) {
            PlanNode targets = effectiveTarget.getPlanNode(connectionsGroup, scope, false);
            if (negatePlan) {
                return filterAttacher.apply(targets).getTrueNode(UnBufferedPlanNode.class);
            }
            return filterAttacher.apply(targets).getFalseNode(UnBufferedPlanNode.class);
        }
        PlanNode invalidValuesDirectOnPath = negatePlan ? path.get().getAdded(connectionsGroup, planNode -> ((FilterPlanNode)filterAttacher.apply((PlanNode)planNode)).getTrueNode(UnBufferedPlanNode.class)) : path.get().getAdded(connectionsGroup, planNode -> ((FilterPlanNode)filterAttacher.apply((PlanNode)planNode)).getFalseNode(UnBufferedPlanNode.class));
        InnerJoin innerJoin = new InnerJoin(effectiveTarget.getPlanNode(connectionsGroup, scope, false), invalidValuesDirectOnPath);
        if (connectionsGroup.getStats().isBaseSailEmpty()) {
            return innerJoin.getJoined(UnBufferedPlanNode.class);
        }
        PlanNode top = innerJoin.getJoined(BufferedPlanNode.class);
        PlanNode discardedRight = innerJoin.getDiscardedRight(BufferedPlanNode.class);
        PlanNode typeFilterPlan = effectiveTarget.getTargetFilter(connectionsGroup, discardedRight);
        typeFilterPlan = effectiveTarget.extend(typeFilterPlan, connectionsGroup, scope, EffectiveTarget.Extend.left, true);
        top = new UnionNode(top, typeFilterPlan);
        BulkedExternalInnerJoin bulkedExternalInnerJoin = new BulkedExternalInnerJoin(effectiveTarget.getPlanNode(connectionsGroup, scope, false), connectionsGroup.getBaseConnection(), path.get().getTargetQueryFragment(new StatementMatcher.Variable("a"), new StatementMatcher.Variable("c"), connectionsGroup.getRdfsSubClassOfReasoner()), true, connectionsGroup.getPreviousStateConnection(), b -> new ValidationTuple(b.getValue("a"), b.getValue("c"), scope, true));
        top = new UnionNode(top, bulkedExternalInnerJoin);
        if (negatePlan) {
            return filterAttacher.apply(top).getTrueNode(UnBufferedPlanNode.class);
        }
        return filterAttacher.apply(top).getFalseNode(UnBufferedPlanNode.class);
    }

    @Override
    public ValidationApproach getPreferedValidationApproach() {
        return ValidationApproach.Transactional;
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        throw new ShaclUnsupportedException(this.getClass().getSimpleName());
    }

    abstract Function<PlanNode, FilterPlanNode> getFilterAttacher();

    String literalToString(Literal literal) {
        IRI datatype = literal.getDatatype();
        if (datatype == null) {
            return "\"" + literal.stringValue() + "\"";
        }
        if (literal.getLanguage().isPresent()) {
            return "\"" + literal.stringValue() + "\"@" + (String)literal.getLanguage().get();
        }
        return "\"" + literal.stringValue() + "\"^^<" + datatype.stringValue() + ">";
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope) {
        if (scope == ConstraintComponent.Scope.propertyShape) {
            PlanNode allTargetsPlan = this.getTargetChain().getEffectiveTarget("target_", ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner()).getPlanNode(connectionsGroup, ConstraintComponent.Scope.nodeShape, true);
            return new Unique(new ShiftToPropertyShape(allTargetsPlan), true);
        }
        return new EmptyNode();
    }
}

