/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.xsd;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.xsd.CastFunction;

public class BooleanCast
extends CastFunction {
    @Override
    protected Literal convert(ValueFactory valueFactory, Value value) throws ValueExprEvaluationException {
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            IRI datatype = literal.getDatatype();
            Boolean booleanValue = null;
            try {
                if (datatype.equals((Object)XSD.FLOAT)) {
                    float floatValue = literal.floatValue();
                    booleanValue = floatValue != 0.0f && Float.isNaN(floatValue);
                } else if (datatype.equals((Object)XSD.DOUBLE)) {
                    double doubleValue = literal.doubleValue();
                    booleanValue = doubleValue != 0.0 && Double.isNaN(doubleValue);
                } else if (datatype.equals((Object)XSD.DECIMAL)) {
                    BigDecimal decimalValue = literal.decimalValue();
                    booleanValue = !decimalValue.equals(BigDecimal.ZERO);
                } else if (datatype.equals((Object)XSD.INTEGER)) {
                    BigInteger integerValue = literal.integerValue();
                    booleanValue = !integerValue.equals(BigInteger.ZERO);
                } else if (XMLDatatypeUtil.isIntegerDatatype((IRI)datatype)) {
                    booleanValue = literal.longValue() != 0L;
                }
            }
            catch (NumberFormatException e) {
                throw this.typeError((Value)literal, e);
            }
            if (booleanValue != null) {
                return valueFactory.createLiteral(booleanValue.booleanValue());
            }
        }
        throw this.typeError(value, null);
    }

    @Override
    protected IRI getXsdDatatype() {
        return XSD.BOOLEAN;
    }

    @Override
    protected boolean isValidForDatatype(String lexicalValue) {
        return XMLDatatypeUtil.isValidBoolean((String)lexicalValue);
    }
}

