/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.lang.invoke.MethodHandles;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.solr.client.solrj.impl.HttpClientBuilderFactory;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.SolrHttpClientBuilder;
import org.apache.solr.client.solrj.impl.SolrPortAwareCookieSpecFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Krb5HttpClientBuilder
implements HttpClientBuilderFactory {
    public static final String LOGIN_CONFIG_PROP = "java.security.auth.login.config";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Configuration jaasConfig = new SolrJaasConfiguration();
    private HttpRequestInterceptor bufferedEntityInterceptor = (request, context) -> {
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest enclosingRequest = (HttpEntityEnclosingRequest)request;
            HttpEntity requestEntity = enclosingRequest.getEntity();
            enclosingRequest.setEntity((HttpEntity)new BufferedHttpEntity(requestEntity));
        }
    };

    public static void regenerateJaasConfiguration() {
        jaasConfig = new SolrJaasConfiguration();
    }

    public SolrHttpClientBuilder getBuilder() {
        return this.getBuilder(HttpClientUtil.getHttpClientBuilder());
    }

    @Override
    public void close() {
        HttpClientUtil.removeRequestInterceptor(this.bufferedEntityInterceptor);
    }

    @Override
    public SolrHttpClientBuilder getHttpClientBuilder(Optional<SolrHttpClientBuilder> builder) {
        return builder.isPresent() ? this.getBuilder(builder.get()) : this.getBuilder();
    }

    public SolrHttpClientBuilder getBuilder(SolrHttpClientBuilder builder) {
        if (System.getProperty(LOGIN_CONFIG_PROP) != null) {
            String configValue = System.getProperty(LOGIN_CONFIG_PROP);
            if (configValue != null) {
                log.info("Setting up SPNego auth with config: " + configValue);
                String useSubjectCredsProp = "javax.security.auth.useSubjectCredsOnly";
                String useSubjectCredsVal = System.getProperty("javax.security.auth.useSubjectCredsOnly");
                if (useSubjectCredsVal == null) {
                    System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
                } else if (!useSubjectCredsVal.toLowerCase(Locale.ROOT).equals("false")) {
                    log.warn("System Property: javax.security.auth.useSubjectCredsOnly set to: " + useSubjectCredsVal + " not false.  SPNego authentication may not be successful.");
                }
                Configuration.setConfiguration(jaasConfig);
                builder.setAuthSchemeRegistryProvider(() -> {
                    Registry authProviders = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(true, false)).build();
                    return authProviders;
                });
                Credentials useJaasCreds = new Credentials(){

                    public String getPassword() {
                        return null;
                    }

                    public Principal getUserPrincipal() {
                        return null;
                    }
                };
                HttpClientUtil.setCookiePolicy("solr-portaware");
                builder.setCookieSpecRegistryProvider(() -> {
                    SolrPortAwareCookieSpecFactory cookieFactory = new SolrPortAwareCookieSpecFactory();
                    Registry cookieRegistry = RegistryBuilder.create().register("solr-portaware", (Object)cookieFactory).build();
                    return cookieRegistry;
                });
                builder.setDefaultCredentialsProvider(() -> {
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(AuthScope.ANY, useJaasCreds);
                    return credentialsProvider;
                });
                HttpClientUtil.addRequestInterceptor(this.bufferedEntityInterceptor);
            }
        } else {
            log.warn("{} is configured without specifying system property '{}'", (Object)this.getClass().getName(), (Object)LOGIN_CONFIG_PROP);
        }
        return builder;
    }

    private static class SolrJaasConfiguration
    extends Configuration {
        private Configuration baseConfig;
        private Set<String> initiateAppNames = new HashSet<String>(Arrays.asList("com.sun.security.jgss.krb5.initiate", "com.sun.security.jgss.initiate"));

        public SolrJaasConfiguration() {
            try {
                this.baseConfig = Configuration.getConfiguration();
            }
            catch (SecurityException e) {
                this.baseConfig = null;
            }
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
            if (this.baseConfig == null) {
                return null;
            }
            log.debug("Login prop: " + System.getProperty(Krb5HttpClientBuilder.LOGIN_CONFIG_PROP));
            String clientAppName = System.getProperty("solr.kerberos.jaas.appname", "Client");
            if (this.initiateAppNames.contains(appName)) {
                log.debug("Using AppConfigurationEntry for appName '" + clientAppName + "' instead of: " + appName);
                return this.baseConfig.getAppConfigurationEntry(clientAppName);
            }
            return this.baseConfig.getAppConfigurationEntry(appName);
        }
    }
}

