/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.Cache;
import org.eclipse.rdf4j.sail.shacl.ast.Identifiable;
import org.eclipse.rdf4j.sail.shacl.ast.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclProperties;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationApproach;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ShiftToPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationReportNode;
import org.eclipse.rdf4j.sail.shacl.results.ValidationResult;

public class NodeShape
extends Shape
implements ConstraintComponent,
Identifiable {
    protected boolean produceValidationReports;

    public NodeShape(boolean produceValidationReports) {
        this.produceValidationReports = produceValidationReports;
    }

    public NodeShape(NodeShape nodeShape) {
        super(nodeShape);
        this.produceValidationReports = nodeShape.produceValidationReports;
    }

    public static NodeShape getInstance(ShaclProperties properties, RepositoryConnection connection, Cache cache, boolean produceValidationReports, ShaclSail shaclSail) {
        Shape shape = cache.get(properties.getId());
        if (shape == null) {
            shape = new NodeShape(produceValidationReports);
            cache.put(properties.getId(), shape);
            shape.populate(properties, connection, cache, shaclSail);
        }
        return (NodeShape)shape;
    }

    @Override
    public void populate(ShaclProperties properties, RepositoryConnection connection, Cache cache, ShaclSail shaclSail) {
        super.populate(properties, connection, cache, shaclSail);
        if (properties.getMinCount() != null) {
            throw new IllegalStateException("NodeShapes do not support sh:MinCount in " + this.getId());
        }
        if (properties.getMaxCount() != null) {
            throw new IllegalStateException("NodeShapes do not support sh:MaxCount in " + this.getId());
        }
        if (properties.isUniqueLang()) {
            throw new IllegalStateException("NodeShapes do not support sh:uniqueLang in " + this.getId());
        }
        if (properties.getQualifiedValueShape() != null) {
            throw new IllegalStateException("NodeShapes do not support sh:qualifiedValueShape in " + this.getId());
        }
        this.constraintComponents = this.getConstraintComponents(properties, connection, cache, shaclSail);
    }

    @Override
    protected NodeShape shallowClone() {
        return new NodeShape(this);
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        super.toModel(subject, predicate, model, cycleDetection);
        model.add(this.getId(), RDF.TYPE, (Value)SHACL.NODE_SHAPE, new Resource[0]);
        if (subject != null) {
            if (predicate == null) {
                model.add(subject, SHACL.NODE, (Value)this.getId(), new Resource[0]);
            } else {
                model.add(subject, predicate, (Value)this.getId(), new Resource[0]);
            }
        }
        if (cycleDetection.contains(this.getId())) {
            return;
        }
        cycleDetection.add(this.getId());
        this.constraintComponents.forEach(c -> c.toModel(this.getId(), null, model, cycleDetection));
    }

    @Override
    public PlanNode generateSparqlValidationPlan(ConnectionsGroup connectionsGroup, boolean logValidationPlans, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        if (this.isDeactivated()) {
            return new EmptyNode();
        }
        PlanNode union = new EmptyNode();
        for (ConstraintComponent constraintComponent : this.constraintComponents) {
            PlanNode validationPlanNode = constraintComponent.generateSparqlValidationPlan(connectionsGroup, logValidationPlans, negatePlan, false, ConstraintComponent.Scope.nodeShape);
            if (!(constraintComponent instanceof PropertyShape) && this.produceValidationReports) {
                validationPlanNode = new ValidationReportNode(validationPlanNode, t -> new ValidationResult(t.getActiveTarget(), t.getActiveTarget(), this, constraintComponent.getConstraintComponent(), this.getSeverity(), t.getScope()));
            }
            union = new UnionNode(union, validationPlanNode);
        }
        return union;
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, boolean logValidationPlans, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        if (this.isDeactivated()) {
            return new EmptyNode();
        }
        PlanNode union = new EmptyNode();
        for (ConstraintComponent constraintComponent : this.constraintComponents) {
            PlanNode validationPlanNode = constraintComponent.generateTransactionalValidationPlan(connectionsGroup, logValidationPlans, overrideTargetNode, ConstraintComponent.Scope.nodeShape);
            if (!(constraintComponent instanceof PropertyShape) && this.produceValidationReports) {
                validationPlanNode = new ValidationReportNode(validationPlanNode, t -> new ValidationResult(t.getActiveTarget(), t.getActiveTarget(), this, constraintComponent.getConstraintComponent(), this.getSeverity(), t.getScope()));
            }
            if (scope == ConstraintComponent.Scope.propertyShape) {
                validationPlanNode = new Unique(new ShiftToPropertyShape(validationPlanNode), true);
            }
            union = new UnionNode(union, validationPlanNode);
        }
        return union;
    }

    @Override
    public ValidationApproach getPreferedValidationApproach() {
        return this.constraintComponents.stream().map(ConstraintComponent::getPreferedValidationApproach).reduce(ValidationApproach::reduce).orElse(ValidationApproach.Transactional);
    }

    @Override
    public Set<ValidationApproach> getSupportedValidationApproaches() {
        return this.constraintComponents.stream().map(ConstraintComponent::getSupportedValidationApproaches).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.NodeConstraintComponent;
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope) {
        PlanNode planNode = this.constraintComponents.stream().map(c -> c.getAllTargetsPlan(connectionsGroup, ConstraintComponent.Scope.nodeShape)).reduce((xva$0, xva$1) -> new UnionNode((PlanNode)xva$0, (PlanNode)xva$1)).orElse(new EmptyNode());
        planNode = new UnionNode(planNode, this.getTargetChain().getEffectiveTarget("_target", ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner()).getPlanNode(connectionsGroup, ConstraintComponent.Scope.nodeShape, true));
        if (scope == ConstraintComponent.Scope.propertyShape) {
            planNode = new Unique(new ShiftToPropertyShape(planNode), true);
        }
        planNode = new Unique(planNode, false);
        return planNode;
    }

    @Override
    public ConstraintComponent deepClone() {
        NodeShape nodeShape = new NodeShape(this);
        nodeShape.constraintComponents = this.constraintComponents.stream().map(ConstraintComponent::deepClone).collect(Collectors.toList());
        return nodeShape;
    }

    @Override
    public SparqlFragment buildSparqlValidNodes_rsx_targetShape(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, ConstraintComponent.Scope scope) {
        List<SparqlFragment> sparqlFragments = this.constraintComponents.stream().map(shape -> shape.buildSparqlValidNodes_rsx_targetShape(subject, object, rdfsSubClassOfReasoner, ConstraintComponent.Scope.nodeShape)).collect(Collectors.toList());
        if (SparqlFragment.isFilterCondition(sparqlFragments)) {
            return SparqlFragment.and(sparqlFragments);
        }
        return SparqlFragment.join(sparqlFragments);
    }
}

