/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ComplexQueryFragment;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BulkedExternalInnerJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.InnerJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.NonUniqueTargetLang;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ShiftToPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.TrimToTarget;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;

public class UniqueLangConstraintComponent
extends AbstractConstraintComponent {
    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.UNIQUE_LANG, (Value)BooleanLiteral.TRUE, new Resource[0]);
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.UniqueLangConstraintComponent;
    }

    @Override
    public PlanNode generateSparqlValidationPlan(ConnectionsGroup connectionsGroup, boolean logValidationPlans, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        assert (!negateChildren) : "There are no subplans!";
        assert (!negatePlan);
        if (!this.getTargetChain().getPath().isPresent()) {
            throw new IllegalStateException("UniqueLang only operates on paths");
        }
        String targetVarPrefix = "target_";
        ComplexQueryFragment complexQueryFragment = this.getComplexQueryFragment(targetVarPrefix, connectionsGroup);
        String query = complexQueryFragment.getQuery();
        return new Select(connectionsGroup.getBaseConnection(), query, null, b -> {
            List<String> targetVars = b.getBindingNames().stream().filter(s -> s.startsWith(targetVarPrefix)).sorted().collect(Collectors.toList());
            ValidationTuple validationTuple = new ValidationTuple((BindingSet)b, targetVars, scope, false);
            return validationTuple;
        });
    }

    private ComplexQueryFragment getComplexQueryFragment(String targetVarPrefix, ConnectionsGroup connectionsGroup) {
        EffectiveTarget effectiveTarget = this.getTargetChain().getEffectiveTarget(targetVarPrefix, ConstraintComponent.Scope.propertyShape, connectionsGroup.getRdfsSubClassOfReasoner());
        String query = effectiveTarget.getQuery(false);
        StatementMatcher.Variable targetVar = effectiveTarget.getTargetVar();
        String pathQuery1 = this.getTargetChain().getPath().map(p -> p.getTargetQueryFragment(effectiveTarget.getTargetVar(), new StatementMatcher.Variable("value1"), connectionsGroup.getRdfsSubClassOfReasoner())).get();
        String pathQuery2 = this.getTargetChain().getPath().map(p -> p.getTargetQueryFragment(effectiveTarget.getTargetVar(), new StatementMatcher.Variable("value2"), connectionsGroup.getRdfsSubClassOfReasoner())).get();
        query = query + "\n FILTER(EXISTS{\n" + query + "\n" + pathQuery1 + "\n" + pathQuery2 + "FILTER(?value1 != ?value2 && lang(?value1) = lang(?value2) && lang(?value1) != \"\")} )";
        return new ComplexQueryFragment(query, targetVarPrefix, targetVar, null);
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, boolean logValidationPlans, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        EffectiveTarget effectiveTarget = this.getTargetChain().getEffectiveTarget("target_", ConstraintComponent.Scope.propertyShape, connectionsGroup.getRdfsSubClassOfReasoner());
        Optional<Path> path = this.getTargetChain().getPath();
        if (!path.isPresent() || scope != ConstraintComponent.Scope.propertyShape) {
            throw new IllegalStateException("UniqueLang only operates on paths");
        }
        if (overrideTargetNode != null) {
            PlanNode targets = effectiveTarget.extend(overrideTargetNode.getPlanNode(), connectionsGroup, scope, EffectiveTarget.Extend.right, false);
            BulkedExternalInnerJoin relevantTargetsWithPath = new BulkedExternalInnerJoin(targets, connectionsGroup.getBaseConnection(), path.get().getTargetQueryFragment(new StatementMatcher.Variable("a"), new StatementMatcher.Variable("c"), connectionsGroup.getRdfsSubClassOfReasoner()), false, null, b -> new ValidationTuple(b.getValue("a"), b.getValue("c"), scope, true));
            NonUniqueTargetLang nonUniqueTargetLang = new NonUniqueTargetLang(relevantTargetsWithPath);
            return new Unique(new TrimToTarget(nonUniqueTargetLang), false);
        }
        if (connectionsGroup.getStats().isBaseSailEmpty()) {
            PlanNode addedTargets = effectiveTarget.getPlanNode(connectionsGroup, scope, false);
            PlanNode addedByPath = path.get().getAdded(connectionsGroup, null);
            PlanNode innerJoin = new InnerJoin(addedTargets, addedByPath).getJoined(UnBufferedPlanNode.class);
            NonUniqueTargetLang nonUniqueTargetLang = new NonUniqueTargetLang(innerJoin);
            return new Unique(new TrimToTarget(nonUniqueTargetLang), false);
        }
        PlanNode addedTargets = effectiveTarget.getPlanNode(connectionsGroup, scope, false);
        PlanNode addedByPath = path.get().getAdded(connectionsGroup, null);
        addedByPath = effectiveTarget.getTargetFilter(connectionsGroup, new Unique(new TrimToTarget(addedByPath), false));
        addedByPath = effectiveTarget.extend(addedByPath, connectionsGroup, scope, EffectiveTarget.Extend.left, false);
        PlanNode mergeNode = new UnionNode(addedTargets, addedByPath);
        mergeNode = new TrimToTarget(mergeNode);
        Unique allRelevantTargets = new Unique(mergeNode, false);
        BulkedExternalInnerJoin relevantTargetsWithPath = new BulkedExternalInnerJoin(allRelevantTargets, connectionsGroup.getBaseConnection(), path.get().getTargetQueryFragment(new StatementMatcher.Variable("a"), new StatementMatcher.Variable("c"), connectionsGroup.getRdfsSubClassOfReasoner()), false, null, b -> new ValidationTuple(b.getValue("a"), b.getValue("c"), scope, true));
        NonUniqueTargetLang nonUniqueTargetLang = new NonUniqueTargetLang(relevantTargetsWithPath);
        return new Unique(new TrimToTarget(nonUniqueTargetLang), false);
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope) {
        if (scope == ConstraintComponent.Scope.propertyShape) {
            PlanNode allTargetsPlan = this.getTargetChain().getEffectiveTarget("target_", ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner()).getPlanNode(connectionsGroup, ConstraintComponent.Scope.nodeShape, true);
            return new Unique(new ShiftToPropertyShape(allTargetsPlan), true);
        }
        return new EmptyNode();
    }

    @Override
    public ConstraintComponent deepClone() {
        return new UniqueLangConstraintComponent();
    }
}

