/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.GlobalValidationExecutionLogging;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.MultiStreamPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PushablePlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FilterPlanNode
implements MultiStreamPlanNode,
PlanNode {
    private static final Logger logger = LoggerFactory.getLogger(FilterPlanNode.class);
    PlanNode parent;
    private PushablePlanNode trueNode;
    private PushablePlanNode falseNode;
    private CloseableIteration<ValidationTuple, SailException> iterator;
    private ValidationExecutionLogger validationExecutionLogger;
    boolean printed = false;

    abstract boolean checkTuple(ValidationTuple var1);

    public FilterPlanNode(PlanNode parent) {
        this.parent = parent = PlanNodeHelper.handleSorting(this, parent);
    }

    public PlanNode getTrueNode(Class<? extends PushablePlanNode> type) {
        if (this.trueNode != null) {
            throw new IllegalStateException();
        }
        this.trueNode = type == BufferedPlanNode.class ? new BufferedPlanNode<FilterPlanNode>(this, "True") : new UnBufferedPlanNode<FilterPlanNode>(this, "True");
        return this.trueNode;
    }

    public PlanNode getFalseNode(Class<? extends PushablePlanNode> type) {
        if (this.falseNode != null) {
            throw new IllegalStateException();
        }
        this.falseNode = type == BufferedPlanNode.class ? new BufferedPlanNode<FilterPlanNode>(this, "False") : new UnBufferedPlanNode<FilterPlanNode>(this, "False");
        return this.falseNode;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        throw new IllegalStateException("Must specify if filter should return false or true nodes!");
    }

    private CloseableIteration<ValidationTuple, SailException> iteratorInternal() {
        return new CloseableIteration<ValidationTuple, SailException>(){
            CloseableIteration<? extends ValidationTuple, SailException> parentIterator;
            ValidationTuple next;
            boolean closed = false;

            private void calculateNext() {
                if (this.parentIterator == null) {
                    this.parentIterator = FilterPlanNode.this.parent.iterator();
                }
                if (this.next != null) {
                    return;
                }
                while (this.parentIterator.hasNext() && this.next == null) {
                    ValidationTuple temp = (ValidationTuple)this.parentIterator.next();
                    if (FilterPlanNode.this.checkTuple(temp)) {
                        if (FilterPlanNode.this.trueNode != null) {
                            FilterPlanNode.this.trueNode.push(temp);
                        } else if (GlobalValidationExecutionLogging.loggingEnabled) {
                            FilterPlanNode.this.validationExecutionLogger.log(FilterPlanNode.this.depth(), FilterPlanNode.this.getClass().getSimpleName() + ":IgnoredAsTrue.next()", temp, FilterPlanNode.this, FilterPlanNode.this.getId(), null);
                        }
                    } else if (FilterPlanNode.this.falseNode != null) {
                        FilterPlanNode.this.falseNode.push(temp);
                    } else if (GlobalValidationExecutionLogging.loggingEnabled) {
                        FilterPlanNode.this.validationExecutionLogger.log(FilterPlanNode.this.depth(), FilterPlanNode.this.getClass().getSimpleName() + ":IgnoredAsFalse.next()", temp, FilterPlanNode.this, FilterPlanNode.this.getId(), null);
                    }
                    this.next = temp;
                }
            }

            public void close() throws SailException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                if (this.parentIterator != null) {
                    this.parentIterator.close();
                }
            }

            public boolean hasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            public ValidationTuple next() throws SailException {
                ValidationTuple temp = this.next;
                this.next = null;
                return temp;
            }

            public void remove() throws SailException {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        if (this.trueNode != null) {
            stringBuilder.append(this.getId() + " -> " + this.trueNode.getId() + " [label=\"true values\"]").append("\n");
        }
        if (this.falseNode != null) {
            stringBuilder.append(this.getId() + " -> " + this.falseNode.getId() + " [label=\"false values\"]").append("\n");
        }
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public void init() {
        if (this.iterator == null) {
            this.iterator = this.iteratorInternal();
        }
    }

    @Override
    public void close() {
        if ((this.trueNode == null || this.trueNode.isClosed()) && (this.falseNode == null || this.falseNode.isClosed())) {
            this.iterator.close();
            this.iterator = null;
        }
    }

    @Override
    public boolean incrementIterator() {
        if (this.iterator.hasNext()) {
            this.iterator.next();
            return true;
        }
        return false;
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return this.parent.producesSorted();
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterPlanNode that = (FilterPlanNode)o;
        return this.parent.equals(that.parent);
    }

    public int hashCode() {
        return Objects.hash(this.parent);
    }
}

