/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.rdfjson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.common.io.CharSink;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.TreeModel;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFWriter;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.RDFJSONWriterSettings;

public class RDFJSONWriter
extends AbstractRDFWriter
implements RDFWriter,
CharSink {
    private final Writer writer;
    private final RDFFormat actualFormat;
    private Model graph;
    private Resource lastWrittenSubject;
    private IRI lastWrittenPredicate;
    private JsonGenerator jg;
    private boolean isEmptyStream;
    private boolean isStreaming;

    public RDFJSONWriter(OutputStream out, RDFFormat actualFormat) {
        this.actualFormat = actualFormat;
        this.writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
    }

    public RDFJSONWriter(Writer writer, RDFFormat actualFormat) {
        this.writer = writer;
        this.actualFormat = actualFormat;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public void startRDF() throws RDFHandlerException {
        super.startRDF();
        try {
            this.isStreaming = this.getWriterConfig().get(RDFJSONWriterSettings.ALLOW_MULTIPLE_OBJECT_VALUES);
            this.jg = this.configureNewJsonFactory().createGenerator(this.writer);
            if (this.getWriterConfig().get(BasicWriterSettings.PRETTY_PRINT).booleanValue()) {
                DefaultIndenter indenter = DefaultIndenter.SYSTEM_LINEFEED_INSTANCE;
                DefaultPrettyPrinter pp = new DefaultPrettyPrinter().withArrayIndenter((DefaultPrettyPrinter.Indenter)indenter).withObjectIndenter((DefaultPrettyPrinter.Indenter)indenter);
                this.jg.setPrettyPrinter((PrettyPrinter)pp);
            }
            if (this.isStreaming) {
                this.isEmptyStream = true;
                this.lastWrittenPredicate = null;
                this.lastWrittenSubject = null;
                this.jg.writeStartObject();
            } else {
                this.graph = new TreeModel();
            }
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        this.checkWritingStarted();
        try {
            try {
                if (this.isStreaming) {
                    if (!this.isEmptyStream) {
                        this.jg.writeEndArray();
                    }
                    this.jg.writeEndObject();
                    this.lastWrittenPredicate = null;
                    this.lastWrittenSubject = null;
                } else {
                    RDFJSONWriter.modelToRdfJsonInternal(this.graph, this.getWriterConfig(), this.jg);
                }
            }
            finally {
                this.jg.close();
                this.writer.flush();
            }
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }

    @Override
    public RDFFormat getRDFFormat() {
        return this.actualFormat;
    }

    @Override
    public Collection<RioSetting<?>> getSupportedSettings() {
        HashSet results = new HashSet(super.getSupportedSettings());
        results.add(BasicWriterSettings.PRETTY_PRINT);
        results.add(RDFJSONWriterSettings.ALLOW_MULTIPLE_OBJECT_VALUES);
        return results;
    }

    @Override
    public void handleComment(String comment) throws RDFHandlerException {
        this.checkWritingStarted();
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.checkWritingStarted();
    }

    @Override
    public void consumeStatement(Statement statement) throws RDFHandlerException {
        if (this.isStreaming) {
            this.consumeStreamingStatement(statement);
        } else {
            this.graph.add(statement);
        }
    }

    public static void writeObject(Value object, Set<Resource> contexts, JsonGenerator jg) throws JsonGenerationException, IOException {
        jg.writeStartObject();
        if (object instanceof Literal) {
            jg.writeObjectField("value", (Object)object.stringValue());
            jg.writeObjectField("type", (Object)"literal");
            Literal l = (Literal)object;
            if (Literals.isLanguageLiteral(l)) {
                jg.writeObjectField("lang", l.getLanguage().orElse(null));
            } else {
                jg.writeObjectField("datatype", (Object)l.getDatatype().stringValue());
            }
        } else if (object instanceof BNode) {
            jg.writeObjectField("value", (Object)RDFJSONWriter.resourceToString((BNode)object));
            jg.writeObjectField("type", (Object)"bnode");
        } else if (object instanceof IRI) {
            jg.writeObjectField("value", (Object)RDFJSONWriter.resourceToString((IRI)object));
            jg.writeObjectField("type", (Object)"uri");
        }
        if (!(contexts == null || contexts.isEmpty() || contexts.size() == 1 && contexts.iterator().next() == null)) {
            jg.writeArrayFieldStart("graphs");
            for (Resource nextContext : contexts) {
                if (nextContext == null) {
                    jg.writeNull();
                    continue;
                }
                jg.writeString(RDFJSONWriter.resourceToString(nextContext));
            }
            jg.writeEndArray();
        }
        jg.writeEndObject();
    }

    public static String resourceToString(Resource uriOrBnode) {
        if (uriOrBnode instanceof IRI) {
            return uriOrBnode.stringValue();
        }
        return "_:" + ((BNode)uriOrBnode).getID();
    }

    public static void modelToRdfJsonInternal(Model graph, WriterConfig writerConfig, JsonGenerator jg) throws IOException {
        if (writerConfig.get(BasicWriterSettings.PRETTY_PRINT).booleanValue()) {
            DefaultIndenter indenter = DefaultIndenter.SYSTEM_LINEFEED_INSTANCE;
            DefaultPrettyPrinter pp = new DefaultPrettyPrinter().withArrayIndenter((DefaultPrettyPrinter.Indenter)indenter).withObjectIndenter((DefaultPrettyPrinter.Indenter)indenter);
            jg.setPrettyPrinter((PrettyPrinter)pp);
        }
        jg.writeStartObject();
        for (Resource nextSubject : graph.subjects()) {
            jg.writeObjectFieldStart(RDFJSONWriter.resourceToString(nextSubject));
            for (IRI nextPredicate : graph.filter(nextSubject, null, null, new Resource[0]).predicates()) {
                jg.writeArrayFieldStart(nextPredicate.stringValue());
                for (Value nextObject : graph.filter(nextSubject, nextPredicate, null, new Resource[0]).objects()) {
                    Set<Resource> contexts = graph.filter(nextSubject, nextPredicate, nextObject, new Resource[0]).contexts();
                    RDFJSONWriter.writeObject(nextObject, contexts, jg);
                }
                jg.writeEndArray();
            }
            jg.writeEndObject();
        }
        jg.writeEndObject();
    }

    private JsonFactory configureNewJsonFactory() {
        JsonFactory nextJsonFactory = new JsonFactory();
        nextJsonFactory.disable(JsonFactory.Feature.INTERN_FIELD_NAMES);
        nextJsonFactory.disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
        nextJsonFactory.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        return nextJsonFactory;
    }

    private void consumeStreamingStatement(Statement statement) throws RDFHandlerException {
        Resource subj = statement.getSubject();
        IRI pred = statement.getPredicate();
        Value obj = statement.getObject();
        Resource context = statement.getContext();
        try {
            if (!subj.equals(this.lastWrittenSubject)) {
                if (this.lastWrittenSubject != null) {
                    this.jg.writeEndArray();
                    this.jg.writeEndObject();
                    this.lastWrittenPredicate = null;
                }
                this.jg.writeObjectFieldStart(RDFJSONWriter.resourceToString(subj));
                this.lastWrittenSubject = subj;
            }
            if (!pred.equals(this.lastWrittenPredicate)) {
                if (this.lastWrittenPredicate != null) {
                    this.jg.writeEndArray();
                }
                this.jg.writeArrayFieldStart(pred.stringValue());
                this.lastWrittenPredicate = pred;
            }
            RDFJSONWriter.writeObject(obj, Collections.singleton(context), this.jg);
            if (this.isEmptyStream) {
                this.isEmptyStream = false;
            }
        }
        catch (IOException e) {
            throw new RDFHandlerException(e);
        }
    }
}

