/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;

public class AllTargetsPlanNode
implements PlanNode {
    private final Select select;
    private StackTraceElement[] stackTrace;
    private boolean printed;
    private ValidationExecutionLogger validationExecutionLogger;

    public AllTargetsPlanNode(ConnectionsGroup connectionsGroup, ArrayDeque<EffectiveTarget.EffectiveTargetObject> chain, List<StatementMatcher.Variable> vars, ConstraintComponent.Scope scope) {
        String query = chain.stream().map(EffectiveTarget.EffectiveTargetObject::getQueryFragment).reduce((a, b) -> a + "\n" + b).orElse("");
        List<String> varNames = vars.stream().map(StatementMatcher.Variable::getName).collect(Collectors.toList());
        this.select = new Select(connectionsGroup.getBaseConnection(), query, null, new AllTargetsBindingSetMapper(varNames, scope, false));
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            final CloseableIteration<? extends ValidationTuple, SailException> iterator;
            {
                this.iterator = AllTargetsPlanNode.this.select.iterator();
            }

            @Override
            public void close() throws SailException {
                this.iterator.close();
            }

            @Override
            protected ValidationTuple loggingNext() throws SailException {
                return (ValidationTuple)this.iterator.next();
            }

            @Override
            protected boolean localHasNext() throws SailException {
                return this.iterator.hasNext();
            }
        };
    }

    @Override
    public int depth() {
        return this.select.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.select.getId() + " -> " + this.getId()).append("\n");
        this.select.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    public String toString() {
        return "AllTargetsPlanNode";
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.select.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return false;
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllTargetsPlanNode that = (AllTargetsPlanNode)o;
        return this.select.equals(that.select);
    }

    public int hashCode() {
        return Objects.hash(this.select);
    }

    static class AllTargetsBindingSetMapper
    implements Function<BindingSet, ValidationTuple> {
        List<String> varNames;
        ConstraintComponent.Scope scope;
        boolean hasValue;

        public AllTargetsBindingSetMapper(List<String> varNames, ConstraintComponent.Scope scope, boolean hasValue) {
            this.varNames = varNames;
            this.scope = scope;
            this.hasValue = hasValue;
        }

        @Override
        public ValidationTuple apply(BindingSet b) {
            return new ValidationTuple(b, this.varNames, this.scope, false);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AllTargetsBindingSetMapper that = (AllTargetsBindingSetMapper)o;
            return this.hasValue == that.hasValue && this.varNames.equals(that.varNames) && this.scope == that.scope;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.varNames, this.scope, this.hasValue, AllTargetsBindingSetMapper.class});
        }
    }
}

