/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin.function.spif;

import java.util.Iterator;
import java.util.List;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.SPIF;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.spin.function.InverseMagicProperty;
import org.eclipse.rdf4j.spin.function.spif.SingleValueToListTransformer;

public class For
implements InverseMagicProperty {
    @Override
    public String getURI() {
        return SPIF.FOR_PROPERTY.toString();
    }

    @Override
    public CloseableIteration<? extends List<? extends Value>, QueryEvaluationException> evaluate(final ValueFactory valueFactory, Value ... args) throws QueryEvaluationException {
        if (args.length != 2) {
            throw new ValueExprEvaluationException(String.format("%s requires 2 arguments, got %d", this.getURI(), args.length));
        }
        if (!(args[0] instanceof Literal)) {
            throw new ValueExprEvaluationException("First list element must be a literal");
        }
        if (!(args[1] instanceof Literal)) {
            throw new ValueExprEvaluationException("Second list element must be a literal");
        }
        final int from = ((Literal)args[0]).intValue();
        final int to = ((Literal)args[1]).intValue();
        return new CloseableIteratorIteration(SingleValueToListTransformer.transform(new Iterator<Value>(){
            int value;
            {
                this.value = from;
            }

            @Override
            public boolean hasNext() {
                return this.value <= to;
            }

            @Override
            public Value next() {
                return valueFactory.createLiteral(this.value++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }));
    }
}

