/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.concurrent.locks;

import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.IterationWrapper;

public class LockingIteration<E, X extends Exception>
extends IterationWrapper<E, X> {
    private final Lock lock;

    public LockingIteration(Lock lock, Iteration<? extends E, X> iter) {
        super(iter);
        assert (lock != null);
        this.lock = lock;
    }

    @Override
    public synchronized boolean hasNext() throws X {
        if (this.isClosed()) {
            return false;
        }
        if (super.hasNext()) {
            return true;
        }
        this.close();
        return false;
    }

    @Override
    public synchronized E next() throws X {
        if (this.isClosed()) {
            throw new NoSuchElementException("Iteration has been closed");
        }
        return super.next();
    }

    @Override
    public synchronized void remove() throws X {
        if (this.isClosed()) {
            throw new IllegalStateException("Iteration has been closed");
        }
        super.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleClose() throws X {
        try {
            super.handleClose();
        }
        finally {
            LockingIteration lockingIteration = this;
            synchronized (lockingIteration) {
                this.lock.release();
            }
        }
    }
}

