/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.jline.reader.EndOfFileException;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class ConsoleIO {
    private static final String PLEASE_OPEN_FIRST = "please open a repository first";
    private final Terminal terminal;
    private final LineReader input;
    private final ConsoleState appInfo;
    private boolean echo = false;
    private boolean quiet = false;
    private boolean force = false;
    private boolean cautious = false;
    private boolean errorWritten;

    public ConsoleIO(InputStream input, OutputStream out, ConsoleState info) throws IOException {
        this.terminal = TerminalBuilder.builder().system(false).streams(input, out).build();
        this.appInfo = info;
        this.input = this.buildLineReader();
    }

    public ConsoleIO(ConsoleState info) throws IOException {
        this.terminal = TerminalBuilder.terminal();
        this.appInfo = info;
        this.input = this.buildLineReader();
    }

    private LineReader buildLineReader() {
        DefaultHistory history = new DefaultHistory();
        LineReader reader = LineReaderBuilder.builder().terminal(this.terminal).history((History)history).build();
        Path file = Paths.get(this.appInfo.getDataDirectory().toString(), "history.txt");
        reader.setVariable("history-file", (Object)file);
        return reader;
    }

    public LineReader getLineReader() {
        return this.input;
    }

    public OutputStream getOutputStream() {
        return this.terminal.output();
    }

    protected String readCommand() throws IOException {
        try {
            String line = this.input.readLine(this.getPrompt());
            if (line == null) {
                return null;
            }
            if ((line = line.trim()).endsWith(".")) {
                line = line.substring(0, line.length() - 1);
            }
            return line;
        }
        catch (EndOfFileException e) {
            return null;
        }
    }

    private String getPrompt() {
        String repositoryID = this.appInfo.getRepositoryID();
        if (this.quiet) {
            return "";
        }
        if (repositoryID != null) {
            return repositoryID + "> ";
        }
        return "> ";
    }

    public String readMultiLineInput() throws IOException {
        return this.readMultiLineInput("> ");
    }

    public String readMultiLineInput(String prompt) throws IOException {
        String line = this.input.readLine(prompt);
        String result = null;
        if (line != null) {
            StringBuilder buf = new StringBuilder(256);
            buf.append(line);
            while (!(line == null || line.length() == 1 && line.endsWith("."))) {
                line = this.input.readLine("> ");
                buf.append('\n');
                buf.append(line);
            }
            buf.setLength(buf.length() - 1);
            result = buf.toString().trim();
        }
        if (this.echo) {
            this.writeln(result);
        }
        return result;
    }

    public String readln(String ... message) throws IOException {
        String prompt = !this.quiet && message.length > 0 && message[0] != null ? message[0] : "";
        String result = this.input.readLine(prompt);
        if (this.echo) {
            this.writeln(result);
        }
        return result;
    }

    public String readPassword(String prompt) throws IOException {
        String result = this.input.readLine(prompt, Character.valueOf('*'));
        if (this.echo && !result.isEmpty()) {
            this.writeln("************");
        }
        return result;
    }

    public void write(String string) {
        this.terminal.writer().print(string);
    }

    public void writeln() {
        this.terminal.writer().println();
    }

    public void writeln(String string) {
        this.terminal.writer().println(string);
    }

    public void writeError(String errMsg) {
        this.terminal.writer().println(errMsg);
        this.errorWritten = true;
    }

    public void writeUnopenedError() {
        this.writeError(PLEASE_OPEN_FIRST);
    }

    public void writeParseError(String prefix, long lineNo, long colNo, String msg) {
        String locationString = RDFParseException.getLocationString((long)lineNo, (long)colNo);
        int locSize = locationString.length();
        StringBuilder builder = new StringBuilder(locSize + prefix.length() + msg.length() + 3);
        builder.append(prefix).append(": ").append(msg);
        if (locSize > 0) {
            builder.append(" ").append(locationString);
        }
        this.writeError(builder.toString());
    }

    public boolean askProceed(String msg, boolean defaultValue) throws IOException {
        boolean result;
        block3: {
            String reply;
            String defaultString;
            String string = defaultString = defaultValue ? "yes" : "no";
            boolean bl = this.force ? true : (result = this.cautious ? false : defaultValue);
            if (this.force || this.cautious) break block3;
            do {
                this.writeln(msg);
                reply = this.readln("Proceed? (yes|no) [" + defaultString + "]: ");
                if ("no".equalsIgnoreCase(reply) || "no.".equalsIgnoreCase(reply)) {
                    result = false;
                } else {
                    if (!"yes".equalsIgnoreCase(reply) && !"yes.".equalsIgnoreCase(reply)) continue;
                    result = true;
                }
                break;
            } while (!reply.trim().isEmpty());
        }
        return result;
    }

    protected void setEcho(boolean echo) {
        this.echo = echo;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setForce() {
        this.force = true;
    }

    public void setCautious() {
        this.cautious = true;
    }

    public boolean wasErrorWritten() {
        return this.errorWritten;
    }
}

