/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.util;

import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.eclipse.rdf4j.sparqlbuilder.core.QueryElement;

public class SparqlBuilderUtils {
    private static final String PAD = " ";

    public static <O> Optional<O> getOrCreateAndModifyOptional(Optional<O> optional, Supplier<O> getter, UnaryOperator<O> operator) {
        return Optional.of(operator.apply(optional.orElseGet(getter)));
    }

    public static void appendAndNewlineIfPresent(Optional<? extends QueryElement> elementOptional, StringBuilder builder) {
        SparqlBuilderUtils.appendQueryElementIfPresent(elementOptional, builder, null, "\n");
    }

    public static void appendQueryElementIfPresent(Optional<? extends QueryElement> queryElementOptional, StringBuilder builder, String prefix, String suffix) {
        SparqlBuilderUtils.appendStringIfPresent(queryElementOptional.map(QueryElement::getQueryString), builder, prefix, suffix);
    }

    public static void appendStringIfPresent(Optional<String> stringOptional, StringBuilder builder, String prefix, String suffix) {
        Optional<String> preOpt = Optional.ofNullable(prefix);
        Optional<String> sufOpt = Optional.ofNullable(suffix);
        stringOptional.ifPresent(string -> {
            preOpt.ifPresent(builder::append);
            builder.append((String)string);
            sufOpt.ifPresent(builder::append);
        });
    }

    public static String getBracedString(String contents) {
        return SparqlBuilderUtils.getEnclosedString("{", "}", contents);
    }

    public static String getBracketedString(String contents) {
        return SparqlBuilderUtils.getEnclosedString("[", "]", contents);
    }

    public static String getParenthesizedString(String contents) {
        return SparqlBuilderUtils.getEnclosedString("(", ")", contents);
    }

    public static String getQuotedString(String contents) {
        return SparqlBuilderUtils.getEnclosedString("\"", "\"", contents, false);
    }

    public static String getLongQuotedString(String contents) {
        return SparqlBuilderUtils.getEnclosedString("'''", "'''", contents, false);
    }

    private static String getEnclosedString(String open, String close, String contents) {
        return SparqlBuilderUtils.getEnclosedString(open, close, contents, true);
    }

    private static String getEnclosedString(String open, String close, String contents, boolean pad) {
        StringBuilder es = new StringBuilder();
        es.append(open);
        if (contents != null && !contents.isEmpty()) {
            es.append(contents);
            if (pad) {
                es.insert(open.length(), PAD).append(PAD);
            }
        }
        es.append(close);
        return es.toString();
    }
}

