/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.concurrent.locks.LockingIteration;
import org.eclipse.rdf4j.common.concurrent.locks.ReadPrefReadWriteLockManager;
import org.eclipse.rdf4j.common.concurrent.locks.ReadWriteLockManager;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.sail.SailConflictException;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.BackingSailSource;
import org.eclipse.rdf4j.sail.base.SailDataset;
import org.eclipse.rdf4j.sail.base.SailSink;
import org.eclipse.rdf4j.sail.base.SailSource;
import org.eclipse.rdf4j.sail.base.SailStore;
import org.eclipse.rdf4j.sail.memory.MemEvaluationStatistics;
import org.eclipse.rdf4j.sail.memory.MemNamespaceStore;
import org.eclipse.rdf4j.sail.memory.MemTripleIterator;
import org.eclipse.rdf4j.sail.memory.model.MemIRI;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemStatement;
import org.eclipse.rdf4j.sail.memory.model.MemStatementIterator;
import org.eclipse.rdf4j.sail.memory.model.MemStatementList;
import org.eclipse.rdf4j.sail.memory.model.MemTriple;
import org.eclipse.rdf4j.sail.memory.model.MemValue;
import org.eclipse.rdf4j.sail.memory.model.MemValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MemorySailStore
implements SailStore {
    private final Logger logger = LoggerFactory.getLogger(MemorySailStore.class);
    private final MemValueFactory valueFactory = new MemValueFactory();
    private final MemStatementList statements = new MemStatementList(256);
    private volatile int currentSnapshot;
    private final MemNamespaceStore namespaceStore = new MemNamespaceStore();
    private final ReadWriteLockManager statementListLockManager;
    private final ReentrantLock txnLockManager = new ReentrantLock();
    private volatile Thread snapshotCleanupThread;
    private final Object snapshotCleanupThreadLockObject = new Object();

    public MemorySailStore(boolean debug) {
        this.statementListLockManager = new ReadPrefReadWriteLockManager(debug);
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public void close() {
        try {
            Lock stLock = this.statementListLockManager.getWriteLock();
            try {
                this.valueFactory.clear();
                this.statements.clear();
            }
            finally {
                stLock.release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public EvaluationStatistics getEvaluationStatistics() {
        return new MemEvaluationStatistics(this.valueFactory, this.statements);
    }

    public SailSource getExplicitSailSource() {
        return new MemorySailSource(true);
    }

    public SailSource getInferredSailSource() {
        return new MemorySailSource(false);
    }

    private Lock openStatementsReadLock() throws SailException {
        try {
            return this.statementListLockManager.getReadLock();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SailException((Throwable)e);
        }
    }

    private CloseableIteration<MemStatement, SailException> createStatementIterator(Resource subj, IRI pred, Value obj, Boolean explicit, int snapshot, Resource ... contexts) {
        MemStatementList l;
        MemStatementList smallestList;
        MemResource[] memContexts;
        MemResource memSubj = this.valueFactory.getMemResource(subj);
        if (subj != null && memSubj == null) {
            return new EmptyIteration();
        }
        MemIRI memPred = this.valueFactory.getMemURI(pred);
        if (pred != null && memPred == null) {
            return new EmptyIteration();
        }
        MemValue memObj = this.valueFactory.getMemValue(obj);
        if (obj != null && memObj == null) {
            return new EmptyIteration();
        }
        if (contexts.length == 0) {
            memContexts = new MemResource[]{};
            smallestList = this.statements;
        } else if (contexts.length == 1 && contexts[0] != null) {
            MemResource memContext = this.valueFactory.getMemResource(contexts[0]);
            if (memContext == null) {
                return new EmptyIteration();
            }
            memContexts = new MemResource[]{memContext};
            smallestList = memContext.getContextStatementList();
        } else {
            LinkedHashSet<MemResource> contextSet = new LinkedHashSet<MemResource>(2 * contexts.length);
            for (Resource context : contexts) {
                MemResource memContext = this.valueFactory.getMemResource(context);
                if (context != null && memContext == null) continue;
                contextSet.add(memContext);
            }
            if (contextSet.isEmpty()) {
                return new EmptyIteration();
            }
            memContexts = contextSet.toArray(new MemResource[contextSet.size()]);
            smallestList = this.statements;
        }
        if (memSubj != null && (l = memSubj.getSubjectStatementList()).size() < smallestList.size()) {
            smallestList = l;
        }
        if (memPred != null && (l = memPred.getPredicateStatementList()).size() < smallestList.size()) {
            smallestList = l;
        }
        if (memObj != null && (l = memObj.getObjectStatementList()).size() < smallestList.size()) {
            smallestList = l;
        }
        return new MemStatementIterator(smallestList, memSubj, memPred, memObj, explicit, snapshot, memContexts);
    }

    private CloseableIteration<MemTriple, SailException> createTripleIterator(Resource subj, IRI pred, Value obj, int snapshot) {
        MemResource memSubj = this.valueFactory.getMemResource(subj);
        if (subj != null && memSubj == null) {
            return new EmptyIteration();
        }
        MemIRI memPred = this.valueFactory.getMemURI(pred);
        if (pred != null && memPred == null) {
            return new EmptyIteration();
        }
        MemValue memObj = this.valueFactory.getMemValue(obj);
        if (obj != null && memObj == null) {
            return new EmptyIteration();
        }
        return new MemTripleIterator(this.statements, memSubj, memPred, memObj, snapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanSnapshots() throws InterruptedException {
        int lastStmtPos;
        HashSet<MemResource> processedSubjects = new HashSet<MemResource>();
        HashSet<MemIRI> processedPredicates = new HashSet<MemIRI>();
        HashSet<MemValue> processedObjects = new HashSet<MemValue>();
        HashSet<MemResource> processedContexts = new HashSet<MemResource>();
        Lock stReadLock = this.statementListLockManager.getReadLock();
        try {
            lastStmtPos = this.statements.size() - 1;
        }
        finally {
            stReadLock.release();
        }
        int nextSnapshot = this.currentSnapshot;
        for (int i = lastStmtPos; i >= 0; --i) {
            Lock stWriteLock = this.statementListLockManager.getWriteLock();
            try {
                MemResource context;
                MemValue obj;
                MemIRI pred;
                MemStatement st;
                lastStmtPos = this.statements.size() - 1;
                i = Math.min(i, lastStmtPos);
                if (i < 0 || (st = this.statements.get(i)).getTillSnapshot() > nextSnapshot) continue;
                MemResource subj = st.getSubject();
                if (processedSubjects.add(subj)) {
                    subj.cleanSnapshotsFromSubjectStatements(nextSnapshot);
                }
                if (processedPredicates.add(pred = st.getPredicate())) {
                    pred.cleanSnapshotsFromPredicateStatements(nextSnapshot);
                }
                if (processedObjects.add(obj = st.getObject())) {
                    obj.cleanSnapshotsFromObjectStatements(nextSnapshot);
                }
                if ((context = st.getContext()) != null && processedContexts.add(context)) {
                    context.cleanSnapshotsFromContextStatements(nextSnapshot);
                }
                this.statements.remove(i);
                continue;
            }
            finally {
                stWriteLock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleSnapshotCleanup() {
        Object object = this.snapshotCleanupThreadLockObject;
        synchronized (object) {
            Thread toCheckSnapshotCleanupThread = this.snapshotCleanupThread;
            if (toCheckSnapshotCleanupThread == null || !toCheckSnapshotCleanupThread.isAlive()) {
                Runnable runnable = () -> {
                    try {
                        this.cleanSnapshots();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        this.logger.warn("snapshot cleanup interrupted");
                    }
                };
                toCheckSnapshotCleanupThread = this.snapshotCleanupThread = new Thread(runnable, "MemoryStore snapshot cleanup");
                toCheckSnapshotCleanupThread.setDaemon(true);
                toCheckSnapshotCleanupThread.start();
            }
        }
    }

    private final class MemorySailDataset
    implements SailDataset {
        private final boolean explicit;
        private final int snapshot;
        private final Lock lock;

        public MemorySailDataset(boolean explicit) throws SailException {
            this.explicit = explicit;
            this.snapshot = -1;
            this.lock = null;
        }

        public MemorySailDataset(boolean explicit, int snapshot) throws SailException {
            this.explicit = explicit;
            this.snapshot = snapshot;
            this.lock = MemorySailStore.this.openStatementsReadLock();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.explicit) {
                sb.append("explicit ");
            } else {
                sb.append("inferred ");
            }
            if (this.snapshot >= 0) {
                sb.append("snapshot ").append(this.snapshot);
            } else {
                sb.append(super.toString());
            }
            return sb.toString();
        }

        public void close() {
            if (this.lock != null) {
                this.lock.release();
            }
        }

        public String getNamespace(String prefix) throws SailException {
            return MemorySailStore.this.namespaceStore.getNamespace(prefix);
        }

        public CloseableIteration<? extends Namespace, SailException> getNamespaces() {
            return new CloseableIteratorIteration(MemorySailStore.this.namespaceStore.iterator());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException {
            ArrayList<MemResource> contextIDs = new ArrayList<MemResource>(32);
            Lock stLock = MemorySailStore.this.openStatementsReadLock();
            try {
                MemValueFactory memValueFactory = MemorySailStore.this.valueFactory;
                synchronized (memValueFactory) {
                    int snapshot = this.getCurrentSnapshot();
                    for (MemResource memResource : MemorySailStore.this.valueFactory.getMemURIs()) {
                        if (!this.isContextResource(memResource, snapshot)) continue;
                        contextIDs.add(memResource);
                    }
                    for (MemResource memResource : MemorySailStore.this.valueFactory.getMemBNodes()) {
                        if (!this.isContextResource(memResource, snapshot)) continue;
                        contextIDs.add(memResource);
                    }
                }
            }
            finally {
                stLock.release();
            }
            return new CloseableIteratorIteration(contextIDs.iterator());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
            CloseableIteration stIter1 = null;
            LockingIteration stIter2 = null;
            boolean allGood = false;
            Lock stLock = MemorySailStore.this.openStatementsReadLock();
            try {
                stIter1 = MemorySailStore.this.createStatementIterator(subj, pred, obj, this.explicit, this.getCurrentSnapshot(), contexts);
                stIter2 = new LockingIteration(stLock, (Iteration)stIter1);
                allGood = true;
                LockingIteration lockingIteration = stIter2;
                return lockingIteration;
            }
            finally {
                if (!allGood) {
                    try {
                        stLock.release();
                    }
                    finally {
                        try {
                            if (stIter2 != null) {
                                stIter2.close();
                            }
                        }
                        finally {
                            if (stIter1 != null) {
                                stIter1.close();
                            }
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CloseableIteration<? extends Triple, SailException> getTriples(Resource subj, IRI pred, Value obj) throws SailException {
            CloseableIteration stIter1 = null;
            LockingIteration stIter2 = null;
            boolean allGood = false;
            Lock stLock = MemorySailStore.this.openStatementsReadLock();
            try {
                stIter1 = MemorySailStore.this.createTripleIterator(subj, pred, obj, this.getCurrentSnapshot());
                stIter2 = new LockingIteration(stLock, (Iteration)stIter1);
                allGood = true;
                LockingIteration lockingIteration = stIter2;
                return lockingIteration;
            }
            finally {
                if (!allGood) {
                    try {
                        stLock.release();
                    }
                    finally {
                        try {
                            if (stIter2 != null) {
                                stIter2.close();
                            }
                        }
                        finally {
                            if (stIter1 != null) {
                                stIter1.close();
                            }
                        }
                    }
                }
            }
        }

        private int getCurrentSnapshot() {
            if (this.snapshot >= 0) {
                return this.snapshot;
            }
            return MemorySailStore.this.currentSnapshot;
        }

        private boolean isContextResource(MemResource memResource, int snapshot) throws SailException {
            MemStatementList contextStatements = memResource.getContextStatementList();
            if (contextStatements.size() == 0) {
                return false;
            }
            try (MemStatementIterator iter = new MemStatementIterator(contextStatements, null, null, null, null, snapshot, new MemResource[0]);){
                boolean bl = iter.hasNext();
                return bl;
            }
        }
    }

    private final class MemorySailSink
    implements SailSink {
        private final boolean explicit;
        private final int serializable;
        private final Lock txnStLock;
        private volatile int nextSnapshot;
        private volatile Set<StatementPattern> observations;
        private volatile boolean txnLock;
        private boolean requireCleanup;

        public MemorySailSink(boolean explicit, boolean serializable) throws SailException {
            this.explicit = explicit;
            this.serializable = serializable ? MemorySailStore.this.currentSnapshot : Integer.MAX_VALUE;
            this.txnStLock = MemorySailStore.this.openStatementsReadLock();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.explicit) {
                sb.append("explicit ");
            } else {
                sb.append("inferred ");
            }
            if (this.txnLock) {
                sb.append("snapshot ").append(this.nextSnapshot);
            } else {
                sb.append(super.toString());
            }
            return sb.toString();
        }

        public synchronized void prepare() throws SailException {
            this.acquireExclusiveTransactionLock();
            if (this.observations != null) {
                for (StatementPattern p : this.observations) {
                    Resource subj = (Resource)p.getSubjectVar().getValue();
                    IRI pred = (IRI)p.getPredicateVar().getValue();
                    Value obj = p.getObjectVar().getValue();
                    Var ctxVar = p.getContextVar();
                    Resource[] contexts = ctxVar == null ? new Resource[]{} : new Resource[]{(Resource)ctxVar.getValue()};
                    try (CloseableIteration iter = MemorySailStore.this.createStatementIterator(subj, pred, obj, null, -1, contexts);){
                        while (iter.hasNext()) {
                            MemStatement st = (MemStatement)((Object)iter.next());
                            int since = st.getSinceSnapshot();
                            int till = st.getTillSnapshot();
                            if ((this.serializable >= since || since >= this.nextSnapshot) && (this.serializable >= till || till >= this.nextSnapshot)) continue;
                            throw new SailConflictException("Observed State has Changed");
                        }
                    }
                }
            }
        }

        public synchronized void flush() throws SailException {
            if (this.txnLock) {
                MemorySailStore.this.currentSnapshot = Math.max(MemorySailStore.this.currentSnapshot, this.nextSnapshot);
                if (this.requireCleanup) {
                    MemorySailStore.this.scheduleSnapshotCleanup();
                }
            }
        }

        public void close() {
            try {
                boolean toCloseTxnLock = this.txnLock;
                this.txnLock = false;
                if (toCloseTxnLock) {
                    MemorySailStore.this.txnLockManager.unlock();
                }
            }
            finally {
                if (this.txnStLock != null) {
                    this.txnStLock.release();
                }
            }
        }

        public synchronized void setNamespace(String prefix, String name) throws SailException {
            this.acquireExclusiveTransactionLock();
            MemorySailStore.this.namespaceStore.setNamespace(prefix, name);
        }

        public synchronized void removeNamespace(String prefix) throws SailException {
            this.acquireExclusiveTransactionLock();
            MemorySailStore.this.namespaceStore.removeNamespace(prefix);
        }

        public synchronized void clearNamespaces() throws SailException {
            this.acquireExclusiveTransactionLock();
            MemorySailStore.this.namespaceStore.clear();
        }

        public synchronized void observe(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
            if (this.observations == null) {
                this.observations = new HashSet<StatementPattern>();
            }
            if (contexts == null) {
                this.observations.add(new StatementPattern(new Var("s", (Value)subj), new Var("p", (Value)pred), new Var("o", obj), new Var("g", null)));
            } else if (contexts.length == 0) {
                this.observations.add(new StatementPattern(new Var("s", (Value)subj), new Var("p", (Value)pred), new Var("o", obj)));
            } else {
                for (Resource ctx : contexts) {
                    this.observations.add(new StatementPattern(new Var("s", (Value)subj), new Var("p", (Value)pred), new Var("o", obj), new Var("g", (Value)ctx)));
                }
            }
        }

        public synchronized void clear(Resource ... contexts) throws SailException {
            this.acquireExclusiveTransactionLock();
            this.requireCleanup = true;
            try (CloseableIteration iter = MemorySailStore.this.createStatementIterator(null, null, null, this.explicit, this.nextSnapshot, contexts);){
                while (iter.hasNext()) {
                    MemStatement st = (MemStatement)((Object)iter.next());
                    st.setTillSnapshot(this.nextSnapshot);
                }
            }
        }

        public synchronized void approve(Resource subj, IRI pred, Value obj, Resource ctx) throws SailException {
            this.acquireExclusiveTransactionLock();
            this.addStatement(subj, pred, obj, ctx, this.explicit);
        }

        public synchronized void deprecate(Statement statement) throws SailException {
            this.acquireExclusiveTransactionLock();
            this.requireCleanup = true;
            if (statement instanceof MemStatement) {
                MemStatement toDeprecate = (MemStatement)statement;
                if ((this.nextSnapshot < 0 || toDeprecate.isInSnapshot(this.nextSnapshot)) && toDeprecate.isExplicit() == this.explicit) {
                    toDeprecate.setTillSnapshot(this.nextSnapshot);
                }
            } else if (statement instanceof LinkedHashModel.ModelStatement && ((LinkedHashModel.ModelStatement)statement).getStatement() instanceof MemStatement) {
                MemStatement toDeprecate = (MemStatement)((LinkedHashModel.ModelStatement)statement).getStatement();
                if ((this.nextSnapshot < 0 || toDeprecate.isInSnapshot(this.nextSnapshot)) && toDeprecate.isExplicit() == this.explicit) {
                    toDeprecate.setTillSnapshot(this.nextSnapshot);
                }
            } else {
                try (CloseableIteration iter = MemorySailStore.this.createStatementIterator(statement.getSubject(), statement.getPredicate(), statement.getObject(), this.explicit, this.nextSnapshot, new Resource[]{statement.getContext()});){
                    while (iter.hasNext()) {
                        MemStatement st = (MemStatement)((Object)iter.next());
                        st.setTillSnapshot(this.nextSnapshot);
                    }
                }
            }
        }

        private void acquireExclusiveTransactionLock() throws SailException {
            if (!this.txnLock) {
                MemorySailStore.this.txnLockManager.lock();
                this.nextSnapshot = MemorySailStore.this.currentSnapshot + 1;
                this.txnLock = true;
            }
        }

        private MemStatement addStatement(Resource subj, IRI pred, Value obj, Resource context, boolean explicit) throws SailException {
            MemResource memContext;
            MemValue memObj;
            MemIRI memPred;
            MemResource memSubj;
            block9: {
                memSubj = MemorySailStore.this.valueFactory.getOrCreateMemResource(subj);
                memPred = MemorySailStore.this.valueFactory.getOrCreateMemURI(pred);
                memObj = MemorySailStore.this.valueFactory.getOrCreateMemValue(obj);
                MemResource memResource = memContext = context == null ? null : MemorySailStore.this.valueFactory.getOrCreateMemResource(context);
                if (memSubj.hasStatements() && memPred.hasStatements() && memObj.hasStatements() && (memContext == null || memContext.hasStatements())) {
                    try (CloseableIteration stIter = MemorySailStore.this.createStatementIterator(memSubj, memPred, memObj, null, 0x7FFFFFFE, new Resource[]{memContext});){
                        if (!stIter.hasNext()) break block9;
                        MemStatement st = (MemStatement)((Object)stIter.next());
                        if (!st.isExplicit() && explicit) {
                            st.setTillSnapshot(this.nextSnapshot);
                            break block9;
                        }
                        if (!st.isInSnapshot(this.nextSnapshot)) {
                            st.setSinceSnapshot(this.nextSnapshot);
                            break block9;
                        }
                        MemStatement memStatement = null;
                        return memStatement;
                    }
                }
            }
            MemStatement st = new MemStatement(memSubj, memPred, memObj, memContext, explicit, this.nextSnapshot);
            MemorySailStore.this.statements.add(st);
            st.addToComponentLists();
            return st;
        }

        public boolean deprecateByQuery(Resource subj, IRI pred, Value obj, Resource[] contexts) {
            this.acquireExclusiveTransactionLock();
            boolean deprecated = false;
            this.requireCleanup = true;
            try (CloseableIteration iter = MemorySailStore.this.createStatementIterator(subj, pred, obj, this.explicit, this.nextSnapshot, contexts);){
                while (iter.hasNext()) {
                    deprecated = true;
                    MemStatement st = (MemStatement)((Object)iter.next());
                    st.setTillSnapshot(this.nextSnapshot);
                }
            }
            return deprecated;
        }
    }

    private final class MemorySailSource
    extends BackingSailSource {
        private final boolean explicit;

        public MemorySailSource(boolean explicit) {
            this.explicit = explicit;
        }

        public SailSink sink(IsolationLevel level) throws SailException {
            return new MemorySailSink(this.explicit, level.isCompatibleWith((IsolationLevel)IsolationLevels.SERIALIZABLE));
        }

        public MemorySailDataset dataset(IsolationLevel level) throws SailException {
            if (level.isCompatibleWith((IsolationLevel)IsolationLevels.SNAPSHOT_READ)) {
                return new MemorySailDataset(this.explicit, MemorySailStore.this.currentSnapshot);
            }
            return new MemorySailDataset(this.explicit);
        }
    }
}

