/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.iterator;

import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;

public class GraphToBindingSetConversionIteration
extends AbstractCloseableIteration<BindingSet, QueryEvaluationException> {
    protected final GraphQueryResult graph;

    public GraphToBindingSetConversionIteration(GraphQueryResult graph) {
        this.graph = graph;
    }

    @Override
    public boolean hasNext() throws QueryEvaluationException {
        return this.graph.hasNext();
    }

    @Override
    public BindingSet next() throws QueryEvaluationException {
        return this.convert((Statement)this.graph.next());
    }

    @Override
    public void remove() throws QueryEvaluationException {
        this.graph.remove();
    }

    protected BindingSet convert(Statement st) {
        QueryBindingSet result = new QueryBindingSet();
        result.addBinding("subject", st.getSubject());
        result.addBinding("predicate", st.getPredicate());
        result.addBinding("object", st.getObject());
        if (st.getContext() != null) {
            result.addBinding("context", st.getContext());
        }
        return result;
    }
}

