/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.contexts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.http.server.ProtocolUtil;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.eclipse.rdf4j.http.server.repository.RepositoryInterceptor;
import org.eclipse.rdf4j.http.server.repository.TupleQueryResultView;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.impl.IteratingTupleQueryResult;
import org.eclipse.rdf4j.query.impl.ListBindingSet;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterFactory;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterRegistry;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class ContextsController
extends AbstractController {
    public ContextsController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"GET", "HEAD"});
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        TupleQueryResultWriterFactory factory = ProtocolUtil.getAcceptableService(request, response, TupleQueryResultWriterRegistry.getInstance());
        if ("GET".equals(request.getMethod())) {
            List<String> columnNames = Arrays.asList("contextID");
            ArrayList<ListBindingSet> contexts = new ArrayList<ListBindingSet>();
            RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);
            try {
                try (RepositoryResult<Resource> contextIter = repositoryCon.getContextIDs();){
                    while (contextIter.hasNext()) {
                        ListBindingSet bindingSet = new ListBindingSet(columnNames, (Value)contextIter.next());
                        contexts.add(bindingSet);
                    }
                }
                model.put("queryResult", new IteratingTupleQueryResult(columnNames, contexts));
                model.put("filenameHint", "contexts");
                model.put("factory", factory);
                model.put("headersOnly", "HEAD".equals(request.getMethod()));
                model.put("connection", repositoryCon);
            }
            catch (RepositoryException e) {
                repositoryCon.close();
                throw new ServerHTTPException("Repository error: " + e.getMessage(), (Throwable)e);
            }
        }
        return new ModelAndView((View)TupleQueryResultView.getInstance(), model);
    }
}

