/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.util.ValueComparator;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.results.ValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationTuple {
    private static final Logger logger = LoggerFactory.getLogger(ValidationTuple.class);
    private static final ValueComparator valueComparator = new ValueComparator();
    private final Value[] chain;
    private final ConstraintComponent.Scope scope;
    private final boolean propertyShapeScopeWithValue;
    private final List<ValidationResult> validationResults;
    private final Set<ValidationTuple> compressedTuples;

    public ValidationTuple(BindingSet bindingSet, String[] variables, ConstraintComponent.Scope scope, boolean hasValue) {
        this(bindingSet, Arrays.asList(variables), scope, hasValue);
    }

    public ValidationTuple(BindingSet bindingSet, List<String> variables, ConstraintComponent.Scope scope, boolean hasValue) {
        this.chain = new Value[variables.size()];
        for (int i = 0; i < variables.size(); ++i) {
            this.chain[i] = bindingSet.getValue(variables.get(i));
        }
        this.scope = scope;
        this.propertyShapeScopeWithValue = hasValue;
        this.validationResults = Collections.emptyList();
        this.compressedTuples = Collections.emptySet();
    }

    public ValidationTuple(List<Value> chain, ConstraintComponent.Scope scope, boolean hasValue) {
        this.chain = chain.toArray(new Value[0]);
        this.scope = scope;
        this.propertyShapeScopeWithValue = hasValue;
        this.validationResults = Collections.emptyList();
        this.compressedTuples = Collections.emptySet();
    }

    public ValidationTuple(Value[] chain, ConstraintComponent.Scope scope, boolean hasValue) {
        this.chain = chain;
        this.scope = scope;
        this.propertyShapeScopeWithValue = hasValue;
        this.validationResults = Collections.emptyList();
        this.compressedTuples = Collections.emptySet();
    }

    public ValidationTuple(Value a, Value c, ConstraintComponent.Scope scope, boolean hasValue) {
        this.chain = new Value[2];
        this.chain[0] = a;
        this.chain[1] = c;
        this.scope = scope;
        this.propertyShapeScopeWithValue = hasValue;
        this.validationResults = Collections.emptyList();
        this.compressedTuples = Collections.emptySet();
    }

    public ValidationTuple(Value subject, ConstraintComponent.Scope scope, boolean hasValue) {
        this.chain = new Value[1];
        this.chain[0] = subject;
        this.scope = scope;
        this.propertyShapeScopeWithValue = hasValue;
        this.validationResults = Collections.emptyList();
        this.compressedTuples = Collections.emptySet();
    }

    private ValidationTuple(List<ValidationResult> validationResults, Value[] chain, ConstraintComponent.Scope scope, boolean propertyShapeScopeWithValue, Set<ValidationTuple> compressedTuples) {
        this.validationResults = Collections.unmodifiableList(validationResults);
        this.chain = chain;
        this.scope = scope;
        this.propertyShapeScopeWithValue = propertyShapeScopeWithValue;
        this.compressedTuples = Collections.unmodifiableSet(compressedTuples);
    }

    public ValidationTuple(ValidationTuple temp, Set<ValidationTuple> compressedTuples) {
        this.validationResults = temp.validationResults;
        this.chain = temp.chain;
        this.scope = temp.scope;
        this.propertyShapeScopeWithValue = temp.propertyShapeScopeWithValue;
        this.compressedTuples = Collections.unmodifiableSet(compressedTuples);
    }

    public boolean sameTargetAs(ValidationTuple other) {
        Value current = this.getActiveTarget();
        Value currentRight = other.getActiveTarget();
        return current.equals(currentRight);
    }

    public boolean hasValue() {
        assert (this.scope != null);
        return this.propertyShapeScopeWithValue || this.scope == ConstraintComponent.Scope.nodeShape;
    }

    public Value getValue() {
        assert (this.scope != null);
        if (this.hasValue()) {
            return this.chain[this.chain.length - 1];
        }
        return null;
    }

    public ConstraintComponent.Scope getScope() {
        return this.scope;
    }

    public int compareActiveTarget(ValidationTuple other) {
        Value left = this.getActiveTarget();
        Value right = other.getActiveTarget();
        return valueComparator.compare(left, right);
    }

    public int compareFullTarget(ValidationTuple other) {
        int min = Math.min(this.getFullChainSize(false), other.getFullChainSize(false));
        List<Value> targetChain = this.getTargetChain(false);
        List<Value> otherTargetChain = other.getTargetChain(false);
        Iterator<Value> iterator = targetChain.iterator();
        for (int i = 0; i < min; ++i) {
            Value value = iterator.next();
            int compare = valueComparator.compare(value, otherTargetChain.get(i));
            if (compare == 0) continue;
            return compare;
        }
        return Integer.compare(this.getFullChainSize(true), other.getFullChainSize(true));
    }

    public List<ValidationResult> getValidationResult() {
        return this.validationResults;
    }

    public ValidationTuple addValidationResult(Function<ValidationTuple, ValidationResult> validationResult) {
        List<ValidationResult> validationResults;
        if (!this.validationResults.isEmpty()) {
            validationResults = new ArrayList<ValidationResult>(this.validationResults);
            validationResults.add(validationResult.apply(this));
        } else {
            validationResults = Collections.singletonList(validationResult.apply(this));
        }
        Set<ValidationTuple> compressedTuples = this.enrichCompressedTuples(t -> t.addValidationResult(validationResult));
        return new ValidationTuple(validationResults, this.chain, this.scope, this.propertyShapeScopeWithValue, compressedTuples);
    }

    public Value getActiveTarget() {
        assert (this.scope != null);
        if (!this.propertyShapeScopeWithValue || this.scope != ConstraintComponent.Scope.propertyShape) {
            return this.chain[this.chain.length - 1];
        }
        assert (this.chain.length >= 2);
        return this.chain[this.chain.length - 2];
    }

    public String toString() {
        return "ValidationTuple{chain=" + Arrays.toString(this.chain) + ", scope=" + (Object)((Object)this.scope) + ", propertyShapeScopeWithValue=" + this.propertyShapeScopeWithValue + ", compressedTuples=" + Arrays.toString(this.compressedTuples.toArray()) + '}';
    }

    public List<ValidationTuple> shiftToNodeShape() {
        assert (this.scope == ConstraintComponent.Scope.propertyShape);
        if (this.compressedTuples.isEmpty()) {
            Value[] chain;
            boolean propertyShapeScopeWithValue = this.propertyShapeScopeWithValue;
            ConstraintComponent.Scope scope = ConstraintComponent.Scope.nodeShape;
            if (this.propertyShapeScopeWithValue) {
                propertyShapeScopeWithValue = false;
                chain = Arrays.copyOf(this.chain, this.chain.length - 1);
            } else {
                chain = this.chain;
            }
            return Collections.singletonList(new ValidationTuple(this.validationResults, chain, scope, propertyShapeScopeWithValue, Collections.emptySet()));
        }
        return this.compressedTuples.stream().map(t -> {
            List<Value> chain = Arrays.asList(t.chain);
            boolean propertyShapeScopeWithValue = t.propertyShapeScopeWithValue;
            ConstraintComponent.Scope scope = ConstraintComponent.Scope.nodeShape;
            if (this.propertyShapeScopeWithValue) {
                propertyShapeScopeWithValue = false;
                chain = chain.subList(0, chain.size() - 1);
            }
            return new ValidationTuple(t.validationResults, chain.toArray(new Value[chain.size()]), scope, propertyShapeScopeWithValue, Collections.emptySet());
        }).collect(Collectors.toList());
    }

    public List<ValidationTuple> shiftToPropertyShapeScope() {
        assert (this.scope == ConstraintComponent.Scope.nodeShape);
        assert (this.chain.length >= 2);
        boolean propertyShapeScopeWithValue = true;
        ConstraintComponent.Scope scope = ConstraintComponent.Scope.propertyShape;
        if (!this.compressedTuples.isEmpty()) {
            return this.compressedTuples.stream().map(t -> new ValidationTuple(t.validationResults, t.chain, scope, propertyShapeScopeWithValue, Collections.emptySet())).collect(Collectors.toList());
        }
        return Collections.singletonList(new ValidationTuple(this.validationResults, this.chain, scope, propertyShapeScopeWithValue, Collections.emptySet()));
    }

    public int getFullChainSize(boolean includePropertyShapeValue) {
        if (!includePropertyShapeValue && this.propertyShapeScopeWithValue) {
            return this.chain.length - 1;
        }
        return this.chain.length;
    }

    public List<Value> getTargetChain(boolean includePropertyShapeValues) {
        if (this.scope == ConstraintComponent.Scope.propertyShape && this.hasValue() && !includePropertyShapeValues) {
            return Collections.unmodifiableList(Arrays.asList(this.chain).subList(0, this.chain.length - 1));
        }
        return Collections.unmodifiableList(Arrays.asList(this.chain));
    }

    public ValidationTuple setValue(Value value) {
        if (value.equals(this.getValue())) {
            return this;
        }
        assert (this.scope == ConstraintComponent.Scope.propertyShape) : "Can't set value on NodeShape scoped ValidationTuple because it will also change the target!";
        Value[] chain = this.propertyShapeScopeWithValue ? Arrays.copyOf(this.chain, this.chain.length) : Arrays.copyOf(this.chain, this.chain.length + 1);
        chain[chain.length - 1] = value;
        Set<ValidationTuple> compressedTuples = this.enrichCompressedTuples(t -> t.setValue(value));
        return new ValidationTuple(this.validationResults, chain, this.scope, true, compressedTuples);
    }

    private Set<ValidationTuple> enrichCompressedTuples(Function<ValidationTuple, ValidationTuple> validationTupleValidationTupleFunction) {
        if (this.compressedTuples.isEmpty()) {
            return this.compressedTuples;
        }
        return this.compressedTuples.stream().map(validationTupleValidationTupleFunction).collect(Collectors.toSet());
    }

    public int compareValue(ValidationTuple other) {
        Value left = this.getValue();
        Value right = other.getValue();
        return valueComparator.compare(left, right);
    }

    public ValidationTuple trimToTarget() {
        if (this.scope == ConstraintComponent.Scope.propertyShape && this.propertyShapeScopeWithValue) {
            Value[] chain = Arrays.copyOf(this.chain, this.chain.length - 1);
            Set<ValidationTuple> compressedTuples = this.enrichCompressedTuples(ValidationTuple::trimToTarget);
            return new ValidationTuple(this.validationResults, chain, this.scope, false, compressedTuples);
        }
        return this;
    }

    public List<ValidationTuple> pop() {
        if (this.compressedTuples.isEmpty()) {
            Value[] chain;
            boolean propertyShapeScopeWithValue = this.propertyShapeScopeWithValue;
            if (this.getScope() == ConstraintComponent.Scope.propertyShape) {
                if (this.hasValue()) {
                    assert (this.chain.length > 1) : "Attempting to pop chain will not leave any elements on the chain! " + this;
                    chain = Arrays.copyOf(this.chain, this.chain.length - 1);
                } else {
                    propertyShapeScopeWithValue = true;
                    chain = this.chain;
                }
            } else {
                assert (this.chain.length > 1) : "Attempting to pop chain will not leave any elements on the chain! " + this;
                chain = Arrays.copyOf(this.chain, this.chain.length - 1);
            }
            return Collections.singletonList(new ValidationTuple(this.validationResults, chain, this.scope, propertyShapeScopeWithValue, Collections.emptySet()));
        }
        return this.compressedTuples.stream().flatMap(t1 -> t1.pop().stream().map(t -> new ValidationTuple(t.validationResults, t.chain, t.scope, t.propertyShapeScopeWithValue, t.compressedTuples))).collect(Collectors.toList());
    }

    public Set<ValidationTuple> getCompressedTuples() {
        return this.compressedTuples;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationTuple that = (ValidationTuple)o;
        return this.propertyShapeScopeWithValue == that.propertyShapeScopeWithValue && Arrays.equals(this.chain, that.chain) && this.scope == that.scope && this.validationResults.equals(that.validationResults) && this.compressedTuples.equals(that.compressedTuples);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{Arrays.hashCode(this.chain), this.scope, this.propertyShapeScopeWithValue, this.validationResults, this.compressedTuples});
    }

    public ValidationTuple join(ValidationTuple right) {
        Set<ValidationTuple> compressedTuples;
        if (this.compressedTuples.isEmpty()) {
            compressedTuples = right.getCompressedTuples();
        } else if (right.compressedTuples.isEmpty()) {
            compressedTuples = this.compressedTuples;
        } else {
            compressedTuples = new HashSet<ValidationTuple>(this.compressedTuples);
            compressedTuples.addAll(right.getCompressedTuples());
        }
        ValidationTuple validationTuple = new ValidationTuple(this.validationResults, this.chain, this.scope, this.propertyShapeScopeWithValue, compressedTuples);
        if (this.scope == ConstraintComponent.Scope.propertyShape) {
            validationTuple = validationTuple.setValue(right.getValue());
        }
        return validationTuple;
    }
}

