/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Pair;

class SplitShardSuggester
extends Suggester {
    SplitShardSuggester() {
    }

    @Override
    public CollectionParams.CollectionAction getAction() {
        return CollectionParams.CollectionAction.SPLITSHARD;
    }

    @Override
    SolrRequest init() {
        Set shards = this.hints.getOrDefault((Object)Suggester.Hint.COLL_SHARD, Collections.emptySet());
        if (shards.isEmpty()) {
            throw new RuntimeException("split-shard requires 'collection' and 'shard'");
        }
        if (shards.size() > 1) {
            throw new RuntimeException("split-shard requires exactly one pair of 'collection' and 'shard'");
        }
        Pair collShard = (Pair)shards.iterator().next();
        Map params = this.hints.getOrDefault((Object)Suggester.Hint.PARAMS, Collections.emptyMap());
        CollectionAdminRequest.SplitShard req = CollectionAdminRequest.splitShard((String)collShard.first()).setShardName((String)collShard.second());
        String splitMethod = (String)params.get("splitMethod");
        if (splitMethod != null) {
            req.setSplitMethod(splitMethod);
        }
        return req;
    }
}

