/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.federated.FedXConnection;
import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.endpoint.ResolvableEndpoint;
import org.eclipse.rdf4j.federated.exception.ExceptionUtil;
import org.eclipse.rdf4j.federated.exception.FedXRuntimeException;
import org.eclipse.rdf4j.federated.util.FedXUtil;
import org.eclipse.rdf4j.federated.write.ReadOnlyWriteStrategy;
import org.eclipse.rdf4j.federated.write.WriteStrategy;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResolver;
import org.eclipse.rdf4j.repository.RepositoryResolverClient;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.helpers.AbstractSail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedX
extends AbstractSail
implements RepositoryResolverClient {
    private static final Logger log = LoggerFactory.getLogger(FedX.class);
    private final List<Endpoint> members = new ArrayList<Endpoint>();
    private FederationContext federationContext;
    private RepositoryResolver repositoryResolver;
    private File dataDir;

    public FedX(List<Endpoint> endpoints) {
        if (endpoints != null) {
            this.members.addAll(endpoints);
        }
        this.setDefaultIsolationLevel((IsolationLevel)IsolationLevels.NONE);
    }

    public void setFederationContext(FederationContext federationContext) {
        this.federationContext = federationContext;
    }

    protected void addMember(Endpoint endpoint) {
        if (this.isInitialized()) {
            this.initializeMember(endpoint);
        }
        this.members.add(endpoint);
    }

    public boolean removeMember(Endpoint endpoint) {
        endpoint.shutDown();
        return this.members.remove(endpoint);
    }

    public WriteStrategy getWriteStrategy() {
        try {
            return this.federationContext.getConfig().getWriteStrategyFactory().newInstance().create(this.members, this.federationContext);
        }
        catch (Exception e) {
            throw new FedXRuntimeException("Failed to instantiate write strategy: " + e.getMessage(), e);
        }
    }

    protected SailConnection getConnectionInternal() throws SailException {
        return new FedXConnection(this, this.federationContext);
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public ValueFactory getValueFactory() {
        return FedXUtil.valueFactory();
    }

    protected void initializeInternal() throws SailException {
        log.debug("Initializing federation....");
        for (Endpoint member : this.members) {
            this.initializeMember(member);
        }
    }

    protected void initializeMember(Endpoint member) throws SailException {
        if (member.isInitialized()) {
            log.warn("Endpoint " + member.getId() + " was already initialized.");
            return;
        }
        if (member instanceof ResolvableEndpoint && this.repositoryResolver != null) {
            ((ResolvableEndpoint)member).setRepositoryResolver(this.repositoryResolver);
        }
        try {
            member.init(this.federationContext);
        }
        catch (RepositoryException e) {
            log.error("Initialization of endpoint " + member.getId() + " failed: " + e.getMessage());
            throw new SailException((Throwable)e);
        }
    }

    public boolean isWritable() throws SailException {
        return !(this.getWriteStrategy() instanceof ReadOnlyWriteStrategy);
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    protected void shutDownInternal() throws SailException {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        for (Endpoint member : this.members) {
            try {
                member.shutDown();
            }
            catch (Exception e) {
                log.error(ExceptionUtil.getExceptionString("Error shutting down endpoint " + member.getId(), e));
                errors.add(e);
            }
        }
        if (errors.size() > 0) {
            throw new SailException("Federation could not be shut down. See logs for details.");
        }
    }

    public List<Endpoint> getMembers() {
        return Collections.unmodifiableList(this.members);
    }

    public void setRepositoryResolver(RepositoryResolver resolver) {
        this.repositoryResolver = resolver;
    }
}

