/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.sail.memory.model.MemIRI;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemStatement;
import org.eclipse.rdf4j.sail.memory.model.MemStatementList;
import org.eclipse.rdf4j.sail.memory.model.MemValue;

public class MemStatementIterator<X extends Exception>
extends LookAheadIteration<MemStatement, X> {
    private final MemStatementList statementList;
    private final MemResource subject;
    private final MemIRI predicate;
    private final MemValue object;
    private final MemResource[] contexts;
    private final boolean explicit;
    private final boolean explicitNotSpecified;
    private final int snapshot;
    private final boolean noIsolation;
    private int statementIdx;
    private boolean exhausted;

    public MemStatementIterator(MemStatementList statementList, MemResource subject, MemIRI predicate, MemValue object, Boolean explicit, int snapshot, MemResource ... contexts) {
        this.statementList = statementList;
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.contexts = contexts;
        if (explicit == null) {
            this.explicitNotSpecified = true;
            this.explicit = false;
        } else {
            this.explicitNotSpecified = false;
            this.explicit = explicit;
        }
        this.snapshot = snapshot;
        this.noIsolation = snapshot < 0;
        this.statementIdx = 0;
    }

    protected MemStatement getNextElement() {
        while (!this.exhausted) {
            MemStatement statement;
            if ((statement = this.statementList.getIfExists(this.statementIdx++)) == null) {
                this.exhausted = true;
                break;
            }
            if (!statement.matchesSPO(this.subject, this.predicate, this.object) || !this.matchesContext(statement) || !this.matchesExplicitAndSnapshot(statement)) continue;
            return statement;
        }
        return null;
    }

    private boolean matchesContext(MemStatement statement) {
        if (this.contexts != null && this.contexts.length > 0) {
            for (MemResource context : this.contexts) {
                if (!statement.exactSameContext(context)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean matchesExplicitAndSnapshot(MemStatement st) {
        return !(!this.explicitNotSpecified && this.explicit != st.isExplicit() || !this.noIsolation && !st.isInSnapshot(this.snapshot));
    }
}

