/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.algebra.MathExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;

public class MathUtil {
    public static final int DEFAULT_DECIMAL_EXPANSION_SCALE = 24;
    private static int decimalExpansionScale = 24;

    public static Literal compute(Literal leftLit, Literal rightLit, MathExpr.MathOp op) throws ValueExprEvaluationException {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        IRI leftDatatype = leftLit.getDatatype();
        IRI rightDatatype = rightLit.getDatatype();
        if (!XMLDatatypeUtil.isNumericDatatype(leftDatatype)) {
            throw new ValueExprEvaluationException("Not a number: " + leftLit);
        }
        if (!XMLDatatypeUtil.isNumericDatatype(rightDatatype)) {
            throw new ValueExprEvaluationException("Not a number: " + rightLit);
        }
        IRI commonDatatype = leftDatatype.equals(XSD.DOUBLE) || rightDatatype.equals(XSD.DOUBLE) ? XSD.DOUBLE : (leftDatatype.equals(XSD.FLOAT) || rightDatatype.equals(XSD.FLOAT) ? XSD.FLOAT : (leftDatatype.equals(XSD.DECIMAL) || rightDatatype.equals(XSD.DECIMAL) ? XSD.DECIMAL : (op == MathExpr.MathOp.DIVIDE ? XSD.DECIMAL : XSD.INTEGER)));
        try {
            if (commonDatatype.equals(XSD.DOUBLE)) {
                double left = leftLit.doubleValue();
                double right = rightLit.doubleValue();
                switch (op) {
                    case PLUS: {
                        return vf.createLiteral(left + right);
                    }
                    case MINUS: {
                        return vf.createLiteral(left - right);
                    }
                    case MULTIPLY: {
                        return vf.createLiteral(left * right);
                    }
                    case DIVIDE: {
                        return vf.createLiteral(left / right);
                    }
                }
                throw new IllegalArgumentException("Unknown operator: " + op);
            }
            if (commonDatatype.equals(XSD.FLOAT)) {
                float left = leftLit.floatValue();
                float right = rightLit.floatValue();
                switch (op) {
                    case PLUS: {
                        return vf.createLiteral(left + right);
                    }
                    case MINUS: {
                        return vf.createLiteral(left - right);
                    }
                    case MULTIPLY: {
                        return vf.createLiteral(left * right);
                    }
                    case DIVIDE: {
                        return vf.createLiteral(left / right);
                    }
                }
                throw new IllegalArgumentException("Unknown operator: " + op);
            }
            if (commonDatatype.equals(XSD.DECIMAL)) {
                BigDecimal left = leftLit.decimalValue();
                BigDecimal right = rightLit.decimalValue();
                switch (op) {
                    case PLUS: {
                        return vf.createLiteral(left.add(right));
                    }
                    case MINUS: {
                        return vf.createLiteral(left.subtract(right));
                    }
                    case MULTIPLY: {
                        return vf.createLiteral(left.multiply(right));
                    }
                    case DIVIDE: {
                        BigDecimal result = null;
                        try {
                            result = left.divide(right, MathContext.UNLIMITED);
                        }
                        catch (ArithmeticException e) {
                            result = left.setScale(MathUtil.getDecimalExpansionScale(), RoundingMode.HALF_UP).divide(right, RoundingMode.HALF_UP);
                        }
                        return vf.createLiteral(result);
                    }
                }
                throw new IllegalArgumentException("Unknown operator: " + op);
            }
            BigInteger left = leftLit.integerValue();
            BigInteger right = rightLit.integerValue();
            switch (op) {
                case PLUS: {
                    return vf.createLiteral(left.add(right));
                }
                case MINUS: {
                    return vf.createLiteral(left.subtract(right));
                }
                case MULTIPLY: {
                    return vf.createLiteral(left.multiply(right));
                }
                case DIVIDE: {
                    throw new RuntimeException("Integer divisions should be processed as decimal divisions");
                }
            }
            throw new IllegalArgumentException("Unknown operator: " + op);
        }
        catch (ArithmeticException | NumberFormatException e) {
            throw new ValueExprEvaluationException(e);
        }
    }

    public static int getDecimalExpansionScale() {
        return decimalExpansionScale;
    }

    public static void setDecimalExpansionScale(int decimalExpansionScale) {
        MathUtil.decimalExpansionScale = decimalExpansionScale;
    }
}

