/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class ShiftToNodeShape
implements PlanNode {
    private StackTraceElement[] stackTrace;
    PlanNode parent;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public ShiftToNodeShape(PlanNode parent) {
        this.parent = parent = PlanNodeHelper.handleSorting(this, parent);
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            final CloseableIteration<? extends ValidationTuple, SailException> parentIterator;
            Iterator<ValidationTuple> iterator;
            {
                this.parentIterator = ShiftToNodeShape.this.parent.iterator();
                this.iterator = Collections.emptyIterator();
            }

            public void calculateNext() {
                if (!this.iterator.hasNext()) {
                    if (this.parentIterator.hasNext()) {
                        List<ValidationTuple> validationTuples = ((ValidationTuple)this.parentIterator.next()).shiftToNodeShape();
                        this.iterator = validationTuples.iterator();
                    }
                    assert (this.iterator.hasNext() || !this.parentIterator.hasNext());
                }
            }

            @Override
            public void localClose() throws SailException {
                this.parentIterator.close();
                this.iterator = Collections.emptyIterator();
            }

            @Override
            protected boolean localHasNext() throws SailException {
                this.calculateNext();
                return this.iterator.hasNext();
            }

            @Override
            protected ValidationTuple loggingNext() throws SailException {
                this.calculateNext();
                return this.iterator.next();
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    public String toString() {
        return "ShiftToNodeShape";
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return false;
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShiftToNodeShape that = (ShiftToNodeShape)o;
        return this.parent.equals(that.parent);
    }

    public int hashCode() {
        return Objects.hash(this.parent);
    }
}

