/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.routing;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.apache.solr.client.solrj.routing.AffinityReplicaListTransformerFactory;
import org.apache.solr.client.solrj.routing.NodePreferenceRulesComparator;
import org.apache.solr.client.solrj.routing.PreferenceRule;
import org.apache.solr.client.solrj.routing.ReplicaListTransformer;
import org.apache.solr.client.solrj.routing.ReplicaListTransformerFactory;
import org.apache.solr.client.solrj.routing.ShufflingReplicaListTransformer;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.NodesSysPropsCacher;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestReplicaListTransformerGenerator {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Random r = new Random();
    private static final ReplicaListTransformer shufflingReplicaListTransformer = new ShufflingReplicaListTransformer(r);
    public static final ReplicaListTransformerFactory RANDOM_RLTF = (configSpec, requestParams, fallback) -> shufflingReplicaListTransformer;
    private final ReplicaListTransformerFactory stableRltFactory;
    private final ReplicaListTransformerFactory defaultRltFactory;
    private final String defaultShardPreferences;
    private final String nodeName;
    private final String localHostAddress;
    private final NodesSysPropsCacher sysPropsCacher;

    public RequestReplicaListTransformerGenerator() {
        this(null);
    }

    public RequestReplicaListTransformerGenerator(ReplicaListTransformerFactory defaultRltFactory) {
        this(defaultRltFactory, null);
    }

    public RequestReplicaListTransformerGenerator(ReplicaListTransformerFactory defaultRltFactory, ReplicaListTransformerFactory stableRltFactory) {
        this(defaultRltFactory, stableRltFactory, null, null, null, null);
    }

    public RequestReplicaListTransformerGenerator(String defaultShardPreferences, String nodeName, String localHostAddress, NodesSysPropsCacher sysPropsCacher) {
        this(null, null, defaultShardPreferences, nodeName, localHostAddress, sysPropsCacher);
    }

    public RequestReplicaListTransformerGenerator(ReplicaListTransformerFactory defaultRltFactory, ReplicaListTransformerFactory stableRltFactory, String defaultShardPreferences, String nodeName, String localHostAddress, NodesSysPropsCacher sysPropsCacher) {
        this.defaultRltFactory = Optional.ofNullable(defaultRltFactory).orElse(RANDOM_RLTF);
        this.stableRltFactory = Optional.ofNullable(stableRltFactory).orElseGet(AffinityReplicaListTransformerFactory::new);
        this.defaultShardPreferences = Optional.ofNullable(defaultShardPreferences).orElse("");
        this.nodeName = nodeName;
        this.localHostAddress = localHostAddress;
        this.sysPropsCacher = sysPropsCacher;
    }

    public ReplicaListTransformer getReplicaListTransformer(SolrParams requestParams) {
        return this.getReplicaListTransformer(requestParams, null);
    }

    public ReplicaListTransformer getReplicaListTransformer(SolrParams requestParams, String defaultShardPreferences) {
        return this.getReplicaListTransformer(requestParams, defaultShardPreferences, null, null, null);
    }

    public ReplicaListTransformer getReplicaListTransformer(SolrParams requestParams, String defaultShardPreferences, String nodeName, String localHostAddress, NodesSysPropsCacher sysPropsCacher) {
        boolean preferLocalShards = requestParams.getBool("preferLocalShards", false);
        defaultShardPreferences = Optional.ofNullable(defaultShardPreferences).orElse(this.defaultShardPreferences);
        String shardsPreferenceSpec = requestParams.get("shards.preference", defaultShardPreferences);
        if (preferLocalShards || !shardsPreferenceSpec.isEmpty()) {
            if (preferLocalShards && !shardsPreferenceSpec.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "preferLocalShards is deprecated and must not be used with shards.preference");
            }
            List<PreferenceRule> preferenceRules = PreferenceRule.from(shardsPreferenceSpec);
            if (preferLocalShards) {
                preferenceRules.add(new PreferenceRule("replica.location", "local"));
            }
            NodePreferenceRulesComparator replicaComp = new NodePreferenceRulesComparator(preferenceRules, requestParams, Optional.ofNullable(nodeName).orElse(this.nodeName), Optional.ofNullable(localHostAddress).orElse(this.localHostAddress), Optional.ofNullable(sysPropsCacher).orElse(this.sysPropsCacher), this.defaultRltFactory, this.stableRltFactory);
            ReplicaListTransformer baseReplicaListTransformer = replicaComp.getBaseReplicaListTransformer();
            if (replicaComp.getSortRules() == null) {
                return baseReplicaListTransformer;
            }
            return new TopLevelReplicaListTransformer(replicaComp, baseReplicaListTransformer);
        }
        return this.defaultRltFactory.getInstance(null, requestParams, RANDOM_RLTF);
    }

    private static final class TopLevelReplicaListTransformer
    implements ReplicaListTransformer {
        private final NodePreferenceRulesComparator replicaComp;
        private final ReplicaListTransformer baseReplicaListTransformer;

        public TopLevelReplicaListTransformer(NodePreferenceRulesComparator replicaComp, ReplicaListTransformer baseReplicaListTransformer) {
            this.replicaComp = replicaComp;
            this.baseReplicaListTransformer = baseReplicaListTransformer;
        }

        @Override
        public void transform(List<?> choices) {
            if (choices.size() > 1) {
                if (log.isDebugEnabled()) {
                    log.debug("Applying the following sorting preferences to replicas: {}", (Object)Arrays.toString(this.replicaComp.getPreferenceRules().toArray()));
                }
                try {
                    choices.sort(this.replicaComp);
                }
                catch (IllegalArgumentException iae) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, iae.getMessage());
                }
                Iterator<?> iter = choices.iterator();
                Object prev = iter.next();
                int idx = 1;
                int boundaryCount = 0;
                int[] boundaries = new int[choices.size() - 1];
                do {
                    Object current;
                    if (this.replicaComp.compare(prev, current = iter.next()) != 0) {
                        boundaries[boundaryCount++] = idx;
                    }
                    prev = current;
                    ++idx;
                } while (iter.hasNext());
                int startIdx = 0;
                for (int i = 0; i < boundaryCount; ++i) {
                    int endIdx = boundaries[i];
                    if (endIdx - startIdx > 1) {
                        this.baseReplicaListTransformer.transform(choices.subList(startIdx, endIdx));
                    }
                    startIdx = endIdx;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Applied sorting preferences to replica list: {}", (Object)Arrays.toString(choices.toArray()));
                }
            }
        }
    }
}

