/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.binary;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import org.eclipse.rdf4j.common.io.ByteSink;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.binary.BinaryRDFConstants;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFWriter;
import org.eclipse.rdf4j.rio.helpers.BinaryRDFWriterSettings;

public class BinaryRDFWriter
extends AbstractRDFWriter
implements RDFWriter,
ByteSink {
    private final Queue<Statement> statementQueue;
    private int bufferSize;
    private final Map<Value, ValueMeta> valueMeta;
    private int nextId = 0;
    private final Queue<Integer> idPool;
    private final DataOutputStream out;
    private int formatVersion;
    private Charset charset;
    private boolean recycleIds;

    public BinaryRDFWriter(OutputStream out) {
        this(out, 8192);
    }

    public BinaryRDFWriter(OutputStream out, int bufferSize) {
        this.out = new DataOutputStream(new BufferedOutputStream(out));
        this.statementQueue = new ArrayDeque<Statement>(bufferSize);
        this.valueMeta = new HashMap<Value, ValueMeta>(bufferSize * 3);
        this.idPool = new ArrayDeque<Integer>(bufferSize);
        this.bufferSize = bufferSize;
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.BINARY;
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        HashSet result = new HashSet(super.getSupportedSettings());
        result.add(BinaryRDFWriterSettings.VERSION);
        result.add(BinaryRDFWriterSettings.BUFFER_SIZE);
        result.add(BinaryRDFWriterSettings.CHARSET);
        result.add(BinaryRDFWriterSettings.RECYCLE_IDS);
        return result;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void startRDF() throws RDFHandlerException {
        super.startRDF();
        this.handleWriterConfig();
        try {
            this.out.write(BinaryRDFConstants.MAGIC_NUMBER);
            this.out.writeInt(this.formatVersion);
            if (this.formatVersion != 1) {
                byte[] charsetBytes = this.charset.toString().getBytes(this.charset);
                this.writeInt(charsetBytes.length);
                this.out.write(charsetBytes);
            }
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    private void handleWriterConfig() {
        WriterConfig config = this.getWriterConfig();
        this.formatVersion = Math.toIntExact((Long)config.get(BinaryRDFWriterSettings.VERSION));
        if (this.formatVersion == 1) {
            this.charset = StandardCharsets.UTF_16BE;
        } else if (this.formatVersion == 2) {
            this.charset = Charset.forName((String)config.get(BinaryRDFWriterSettings.CHARSET));
        } else {
            throw new IllegalArgumentException("Unsupported binary RDF version: " + this.formatVersion);
        }
        if (config.isSet(BinaryRDFWriterSettings.BUFFER_SIZE)) {
            this.bufferSize = Math.toIntExact((Long)config.get(BinaryRDFWriterSettings.BUFFER_SIZE));
        }
        this.recycleIds = (Boolean)config.get(BinaryRDFWriterSettings.RECYCLE_IDS);
    }

    public void endRDF() throws RDFHandlerException {
        this.checkWritingStarted();
        try {
            while (!this.statementQueue.isEmpty()) {
                this.writeStatement();
            }
            this.out.writeByte(127);
            this.out.flush();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.checkWritingStarted();
        try {
            this.out.writeByte(0);
            this.writeString(prefix);
            this.writeString(uri);
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleComment(String comment) throws RDFHandlerException {
        this.checkWritingStarted();
        try {
            this.out.writeByte(2);
            this.writeString(comment);
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    protected void consumeStatement(Statement st) {
        this.statementQueue.add(st);
        this.incValueFreq((Value)st.getSubject());
        this.incValueFreq((Value)st.getPredicate());
        this.incValueFreq(st.getObject());
        this.incValueFreq((Value)st.getContext());
        if (this.statementQueue.size() < this.bufferSize) {
            return;
        }
        try {
            this.writeStatement();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    private void writeStatement() throws RDFHandlerException, IOException {
        Statement st = this.statementQueue.remove();
        this.out.writeByte(1);
        this.writeValueOrId((Value)st.getSubject());
        this.writeValueOrId((Value)st.getPredicate());
        this.writeValueOrId(st.getObject());
        this.writeValueOrId((Value)st.getContext());
    }

    private void incValueFreq(Value v) {
        if (v == null) {
            return;
        }
        ValueMeta meta = this.valueMeta.get(v);
        if (meta == null) {
            this.valueMeta.put(v, new ValueMeta(1L));
        } else {
            ++meta.frequency;
            if (meta.frequency == 2L && !meta.hasId()) {
                this.assignId(v, meta);
            }
        }
    }

    private void assignId(Value v, ValueMeta meta) {
        Integer id = this.idPool.poll();
        if (id == null) {
            id = this.nextId++;
        }
        meta.id = id;
        try {
            this.out.writeByte(3);
            this.writeInt(id);
            this.writeValue(v);
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    private void writeValueOrId(Value value) throws RDFHandlerException, IOException {
        if (value == null) {
            this.out.writeByte(0);
        } else {
            ValueMeta meta = this.valueMeta.get(value);
            if (meta.hasId()) {
                this.out.writeByte(6);
                this.writeInt(meta.id);
            } else {
                this.writeValue(value);
            }
            --meta.frequency;
            if (meta.frequency == 0L) {
                if (!meta.hasId()) {
                    this.valueMeta.remove(value);
                } else if (this.recycleIds) {
                    this.valueMeta.remove(value);
                    this.idPool.add(meta.id);
                }
            }
        }
    }

    private void writeValue(Value value) throws RDFHandlerException, IOException {
        if (value instanceof IRI) {
            this.writeURI((IRI)value);
        } else if (value instanceof BNode) {
            this.writeBNode((BNode)value);
        } else if (value instanceof Literal) {
            this.writeLiteral((Literal)value);
        } else if (value instanceof Triple) {
            this.writeTriple((Triple)value);
        } else {
            throw new RDFHandlerException("Unknown Value object type: " + value.getClass());
        }
    }

    private void writeURI(IRI uri) throws IOException {
        this.out.writeByte(1);
        this.writeString(uri.toString());
    }

    private void writeBNode(BNode bnode) throws IOException {
        this.out.writeByte(2);
        this.writeString(bnode.getID());
    }

    private void writeLiteral(Literal literal) throws IOException {
        String label = literal.getLabel();
        IRI datatype = literal.getDatatype();
        Optional language = literal.getLanguage();
        if (language.isPresent()) {
            this.out.writeByte(4);
            this.writeString(label);
            this.writeString((String)language.get());
        } else if (datatype.equals((Object)XSD.STRING)) {
            this.out.writeByte(3);
            this.writeString(label);
        } else {
            this.out.writeByte(5);
            this.writeString(label);
            this.writeString(datatype.toString());
        }
    }

    private void writeTriple(Triple triple) throws IOException {
        this.out.writeByte(7);
        this.writeValue((Value)triple.getSubject());
        this.writeValue((Value)triple.getPredicate());
        this.writeValue(triple.getObject());
    }

    private void writeString(String s) throws IOException {
        byte[] bytes = s.getBytes(this.charset);
        if (this.formatVersion == 1) {
            this.writeInt(s.length());
        } else {
            this.writeInt(bytes.length);
        }
        this.out.write(bytes);
    }

    private void writeInt(int i) throws IOException {
        if (this.formatVersion == 1) {
            this.out.writeInt(i);
        } else {
            IOUtil.writeVarInt((OutputStream)this.out, (int)i);
        }
    }

    private static class ValueMeta {
        private long frequency;
        private int id = -1;

        public ValueMeta(long frequency) {
            this.frequency = frequency;
        }

        private boolean hasId() {
            return this.id != -1;
        }
    }
}

