/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;

public class DistinctIteration<E, X extends Exception>
extends FilterIteration<E, X> {
    private final Set<E> excludeSet;

    public DistinctIteration(Iteration<? extends E, ? extends X> iter) {
        super(iter);
        this.excludeSet = this.makeSet();
    }

    public DistinctIteration(Iteration<? extends E, ? extends X> iter, Supplier<Set<E>> setMaker) {
        super(iter);
        this.excludeSet = setMaker.get();
    }

    @Override
    protected boolean accept(E object) throws X {
        if (this.inExcludeSet(object)) {
            return false;
        }
        this.add(object);
        return true;
    }

    private boolean inExcludeSet(E object) {
        return this.excludeSet.contains(object);
    }

    protected boolean add(E object) throws X {
        return this.excludeSet.add(object);
    }

    protected Set<E> makeSet() {
        return new HashSet();
    }
}

