/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.common.iterator.ConvertingIterator;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.AbstractBindingSet;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.impl.SimpleBinding;

public class QueryBindingSet
extends AbstractBindingSet
implements MutableBindingSet {
    private static final long serialVersionUID = -2010715346095527301L;
    private final Map<String, Value> bindings;

    public QueryBindingSet() {
        this(8);
    }

    public QueryBindingSet(int capacity) {
        this.bindings = new HashMap<String, Value>(capacity * 2);
    }

    public QueryBindingSet(BindingSet bindingSet) {
        this(bindingSet.size());
        this.addAll(bindingSet);
    }

    public void addAll(BindingSet bindingSet) {
        if (bindingSet instanceof QueryBindingSet) {
            this.bindings.putAll(((QueryBindingSet)bindingSet).bindings);
        } else {
            for (Binding binding : bindingSet) {
                this.addBinding(binding);
            }
        }
    }

    @Override
    public void addBinding(Binding binding) {
        this.addBinding(binding.getName(), binding.getValue());
    }

    @Override
    public void addBinding(String name, Value value) {
        assert (!this.bindings.containsKey(name)) : "variable already bound: " + name;
        this.setBinding(name, value);
    }

    @Override
    public void setBinding(Binding binding) {
        this.setBinding(binding.getName(), binding.getValue());
    }

    @Override
    public void setBinding(String name, Value value) {
        this.bindings.put(name, value);
    }

    public void removeBinding(String name) {
        this.bindings.remove(name);
    }

    public void removeAll(Collection<String> bindingNames) {
        this.bindings.keySet().removeAll(bindingNames);
    }

    public void retainAll(Collection<String> bindingNames) {
        this.bindings.keySet().retainAll(bindingNames);
    }

    @Override
    public Set<String> getBindingNames() {
        return this.bindings.keySet();
    }

    @Override
    public Value getValue(String bindingName) {
        return this.bindings.get(bindingName);
    }

    @Override
    public Binding getBinding(String bindingName) {
        Value value = this.getValue(bindingName);
        if (value != null) {
            return new SimpleBinding(bindingName, value);
        }
        return null;
    }

    @Override
    public boolean hasBinding(String bindingName) {
        return this.bindings.containsKey(bindingName);
    }

    @Override
    public Iterator<Binding> iterator() {
        Iterator entries = this.bindings.entrySet().stream().filter(entry -> entry.getValue() != null).iterator();
        return new ConvertingIterator<Map.Entry<String, Value>, Binding>(entries){

            @Override
            protected Binding convert(Map.Entry<String, Value> entry) {
                return new SimpleBinding(entry.getKey(), entry.getValue());
            }
        };
    }

    @Override
    public int size() {
        return this.bindings.size();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof QueryBindingSet) {
            return this.bindings.equals(((QueryBindingSet)other).bindings);
        }
        return super.equals(other);
    }
}

