/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Objects;
import java.util.function.Function;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalFilterByQuery
extends FilterPlanNode {
    private static final Logger logger = LoggerFactory.getLogger(ExternalFilterByQuery.class);
    private final SailConnection connection;
    private final ParsedQuery query;
    private final Dataset dataset;
    private final StatementMatcher.Variable queryVariable;
    private final Function<ValidationTuple, Value> filterOn;
    private final String queryString;

    public ExternalFilterByQuery(SailConnection connection, Resource[] dataGraph, PlanNode parent, String queryFragment, StatementMatcher.Variable queryVariable, Function<ValidationTuple, Value> filterOn) {
        super(parent);
        this.connection = connection;
        this.queryVariable = queryVariable;
        this.filterOn = filterOn;
        QueryParserFactory queryParserFactory = (QueryParserFactory)QueryParserRegistry.getInstance().get(QueryLanguage.SPARQL).get();
        this.queryString = queryFragment = "SELECT ?" + queryVariable.getName() + " WHERE {\n" + (String)queryFragment + "\n}";
        try {
            this.query = queryParserFactory.getParser().parseQuery((String)queryFragment, null);
        }
        catch (MalformedQueryException e) {
            logger.error("Malformed query: \n{}", queryFragment);
            throw e;
        }
        this.dataset = PlanNodeHelper.asDefaultGraphDataset(dataGraph);
    }

    @Override
    boolean checkTuple(ValidationTuple t) {
        Value value = this.filterOn.apply(t);
        MapBindingSet bindings = new MapBindingSet();
        bindings.addBinding(this.queryVariable.getName(), value);
        try (CloseableIteration<? extends BindingSet, QueryEvaluationException> bindingSet = this.connection.evaluate(this.query.getTupleExpr(), this.dataset, bindings, false);){
            boolean bl = bindingSet.hasNext();
            return bl;
        }
    }

    @Override
    public String toString() {
        return "ExternalFilterByQuery{, queryString=" + this.queryString.replace("\n", "\t") + ", queryVariable='" + this.queryVariable.toString().replace("\n", "  ") + "'}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExternalFilterByQuery that = (ExternalFilterByQuery)o;
        if (this.connection instanceof MemoryStoreConnection && that.connection instanceof MemoryStoreConnection) {
            return ((MemoryStoreConnection)this.connection).getSail().equals(((MemoryStoreConnection)that.connection).getSail()) && Objects.equals(this.dataset, that.dataset) && this.queryVariable.equals(that.queryVariable) && this.filterOn.equals(that.filterOn) && this.queryString.equals(that.queryString);
        }
        return this.connection.equals(that.connection) && this.queryVariable.equals(that.queryVariable) && Objects.equals(this.dataset, that.dataset) && this.filterOn.equals(that.filterOn) && this.queryString.equals(that.queryString);
    }

    @Override
    public int hashCode() {
        if (this.connection instanceof MemoryStoreConnection) {
            return Objects.hash(super.hashCode(), ((MemoryStoreConnection)this.connection).getSail(), this.queryVariable, this.filterOn, this.dataset, this.queryString);
        }
        return Objects.hash(super.hashCode(), this.connection, this.queryVariable, this.filterOn, this.dataset, this.queryString);
    }
}

