/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.base;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategyFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.StrictEvaluationStrategyFactory;
import org.eclipse.rdf4j.query.algebra.helpers.QueryModelTreeToGenericPlanNode;
import org.eclipse.rdf4j.query.explanation.Explanation;
import org.eclipse.rdf4j.query.explanation.ExplanationImpl;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.UnknownSailTransactionStateException;
import org.eclipse.rdf4j.sail.UpdateContext;
import org.eclipse.rdf4j.sail.base.DelegatingSailSource;
import org.eclipse.rdf4j.sail.base.SailClosable;
import org.eclipse.rdf4j.sail.base.SailClosingIteration;
import org.eclipse.rdf4j.sail.base.SailDataset;
import org.eclipse.rdf4j.sail.base.SailDatasetTripleSource;
import org.eclipse.rdf4j.sail.base.SailSink;
import org.eclipse.rdf4j.sail.base.SailSource;
import org.eclipse.rdf4j.sail.base.SailStore;
import org.eclipse.rdf4j.sail.base.UnionSailSource;
import org.eclipse.rdf4j.sail.helpers.AbstractNotifyingSailConnection;
import org.eclipse.rdf4j.sail.helpers.AbstractSail;
import org.eclipse.rdf4j.sail.inferencer.InferencerConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SailSourceConnection
extends AbstractNotifyingSailConnection
implements InferencerConnection,
FederatedServiceResolverClient {
    private static final Logger logger = LoggerFactory.getLogger(SailSourceConnection.class);
    private final Map<UpdateContext, SailDataset> datasets = new HashMap<UpdateContext, SailDataset>();
    private final Map<UpdateContext, SailSink> explicitSinks = new HashMap<UpdateContext, SailSink>();
    private volatile SailDataset explicitOnlyDataset;
    private volatile SailDataset inferredOnlyDataset;
    private volatile SailSink inferredOnlySink;
    private final ValueFactory vf;
    private final SailStore store;
    private final IsolationLevel defaultIsolationLevel;
    private volatile SailSource explicitOnlyBranch;
    private volatile SailSource inferredOnlyBranch;
    private volatile SailSource includeInferredBranch;
    private final EvaluationStrategyFactory evalStratFactory;
    private volatile FederatedServiceResolver federatedServiceResolver;
    static final Resource[] NULL_CTX = new Resource[]{null};
    private boolean trackResultSize;
    private boolean cloneTupleExpression = true;
    private boolean trackTime;

    protected SailSourceConnection(AbstractSail sail, SailStore store, FederatedServiceResolver resolver) {
        this(sail, store, (EvaluationStrategyFactory)new StrictEvaluationStrategyFactory(resolver));
    }

    protected SailSourceConnection(AbstractSail sail, SailStore store, EvaluationStrategyFactory evalStratFactory) {
        super(sail);
        this.vf = sail.getValueFactory();
        this.store = store;
        this.defaultIsolationLevel = sail.getDefaultIsolationLevel();
        this.evalStratFactory = evalStratFactory;
        this.federatedServiceResolver = evalStratFactory instanceof StrictEvaluationStrategyFactory ? ((StrictEvaluationStrategyFactory)evalStratFactory).getFederatedServiceResolver() : null;
    }

    public FederatedServiceResolver getFederatedServiceResolver() {
        return this.federatedServiceResolver;
    }

    public void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        this.federatedServiceResolver = resolver;
    }

    protected EvaluationStrategy getEvaluationStrategy(Dataset dataset, TripleSource tripleSource) {
        EvaluationStrategy evalStrat = this.evalStratFactory.createEvaluationStrategy(dataset, tripleSource, this.store.getEvaluationStatistics());
        if (this.federatedServiceResolver != null && evalStrat instanceof FederatedServiceResolverClient) {
            ((FederatedServiceResolverClient)evalStrat).setFederatedServiceResolver(this.federatedServiceResolver);
        }
        return evalStrat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        this.flush();
        logger.trace("Incoming query model:\n{}", (Object)tupleExpr);
        if (this.cloneTupleExpression) {
            tupleExpr = tupleExpr.clone();
        }
        if (!(tupleExpr instanceof QueryRoot)) {
            tupleExpr = new QueryRoot(tupleExpr);
        }
        SailSource branch = null;
        SailDataset rdfDataset = null;
        CloseableIteration iteration = null;
        boolean allGood = false;
        try {
            branch = this.branch(IncludeInferred.fromBoolean(includeInferred));
            rdfDataset = branch.dataset(this.getIsolationLevel());
            SailDatasetTripleSource tripleSource = new SailDatasetTripleSource(this.vf, rdfDataset);
            EvaluationStrategy strategy = this.getEvaluationStrategy(dataset, tripleSource);
            if (this.trackResultSize) {
                strategy.setTrackResultSize(this.trackResultSize);
            }
            if (this.trackTime) {
                strategy.setTrackTime(this.trackTime);
            }
            tupleExpr = strategy.optimize(tupleExpr, this.store.getEvaluationStatistics(), bindings);
            logger.trace("Optimized query model:\n{}", (Object)tupleExpr);
            QueryEvaluationStep qes = strategy.precompile(tupleExpr);
            iteration = qes.evaluate(EmptyBindingSet.getInstance());
            iteration = this.interlock(iteration, rdfDataset, branch);
            allGood = true;
            CloseableIteration closeableIteration = iteration;
            return closeableIteration;
        }
        catch (QueryEvaluationException e) {
            throw new SailException((Throwable)e);
        }
        finally {
            if (!allGood) {
                try {
                    if (iteration != null) {
                        iteration.close();
                    }
                }
                finally {
                    try {
                        if (rdfDataset != null) {
                            rdfDataset.close();
                        }
                    }
                    finally {
                        if (branch != null) {
                            branch.close();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Explanation explain(Explanation.Level level, TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred, int timeoutSeconds) {
        queryTimedOut = false;
        try {
            switch (2.$SwitchMap$org$eclipse$rdf4j$query$explanation$Explanation$Level[level.ordinal()]) {
                case 1: {
                    this.trackTime = true;
                    this.trackResultSize = true;
                    this.cloneTupleExpression = false;
                    queryTimedOut = this.runQueryForExplain(tupleExpr, dataset, bindings, includeInferred, timeoutSeconds);
                    ** break;
lbl10:
                    // 1 sources

                    break;
                }
                case 2: {
                    this.trackResultSize = true;
                    this.cloneTupleExpression = false;
                    queryTimedOut = this.runQueryForExplain(tupleExpr, dataset, bindings, includeInferred, timeoutSeconds);
                    ** break;
lbl16:
                    // 1 sources

                    break;
                }
                case 3: {
                    this.cloneTupleExpression = false;
                    this.evaluate(tupleExpr, dataset, bindings, includeInferred).close();
                    ** break;
lbl21:
                    // 1 sources

                    break;
                }
                case 4: {
                    ** break;
lbl24:
                    // 1 sources

                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported query explanation level: " + level);
                }
            }
        }
        finally {
            this.cloneTupleExpression = true;
            this.trackResultSize = false;
            this.trackTime = false;
        }
        converter = new QueryModelTreeToGenericPlanNode((QueryModelNode)tupleExpr);
        tupleExpr.visit((QueryModelVisitor)converter);
        return new ExplanationImpl(converter.getGenericPlanNode(), queryTimedOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runQueryForExplain(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred, int timeoutSeconds) {
        AtomicBoolean timedOut = new AtomicBoolean(false);
        Thread currentThread = Thread.currentThread();
        Thread selfInterruptOnTimeoutThread = new Thread(() -> {
            try {
                TimeUnit.SECONDS.sleep(timeoutSeconds);
                currentThread.interrupt();
                timedOut.set(true);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        try {
            block17: {
                selfInterruptOnTimeoutThread.start();
                try (CloseableIteration evaluate = this.evaluate(tupleExpr, dataset, bindings, includeInferred);){
                    while (evaluate.hasNext()) {
                        if (Thread.interrupted()) {
                            break;
                        }
                        evaluate.next();
                    }
                }
                catch (Exception e) {
                    if (timedOut.get()) break block17;
                    throw e;
                }
            }
            boolean bl = timedOut.get();
            return bl;
        }
        finally {
            selfInterruptOnTimeoutThread.interrupt();
            try {
                selfInterruptOnTimeoutThread.join();
            }
            catch (InterruptedException interruptedException) {}
            Thread.interrupted();
        }
    }

    protected void closeInternal() throws SailException {
    }

    protected CloseableIteration<? extends Resource, SailException> getContextIDsInternal() throws SailException {
        this.flush();
        SailSource branch = this.branch(IncludeInferred.explicitOnly);
        SailDataset snapshot = branch.dataset(this.getIsolationLevel());
        return SailClosingIteration.makeClosable(snapshot.getContextIDs(), snapshot, branch);
    }

    protected CloseableIteration<? extends Statement, SailException> getStatementsInternal(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        this.flush();
        SailSource branch = this.branch(IncludeInferred.fromBoolean(includeInferred));
        SailDataset snapshot = branch.dataset(this.getIsolationLevel());
        return SailClosingIteration.makeClosable(snapshot.getStatements(subj, pred, obj, contexts), snapshot, branch);
    }

    protected long sizeInternal(Resource ... contexts) throws SailException {
        this.flush();
        try (Stream stream = this.getStatementsInternal(null, null, null, false, contexts).stream();){
            long l = stream.count();
            return l;
        }
    }

    protected CloseableIteration<? extends Namespace, SailException> getNamespacesInternal() throws SailException {
        SailSource branch = this.branch(IncludeInferred.explicitOnly);
        SailDataset snapshot = branch.dataset(this.getIsolationLevel());
        return SailClosingIteration.makeClosable(snapshot.getNamespaces(), snapshot, branch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getNamespaceInternal(String prefix) throws SailException {
        SailSource branch = null;
        SailDataset snapshot = null;
        try {
            branch = this.branch(IncludeInferred.explicitOnly);
            snapshot = branch.dataset(this.getIsolationLevel());
            String string = snapshot.getNamespace(prefix);
            return string;
        }
        finally {
            try {
                if (snapshot != null) {
                    snapshot.close();
                }
            }
            finally {
                if (branch != null) {
                    branch.close();
                }
            }
        }
    }

    protected void startTransactionInternal() throws SailException {
        assert (this.explicitOnlyBranch == null);
        assert (this.inferredOnlyBranch == null);
        assert (this.includeInferredBranch == null);
        IsolationLevel level = this.getTransactionIsolation();
        if (!IsolationLevels.NONE.isCompatibleWith(level)) {
            this.explicitOnlyBranch = this.store.getExplicitSailSource().fork();
            this.inferredOnlyBranch = this.store.getInferredSailSource().fork();
            this.includeInferredBranch = new UnionSailSource(this.inferredOnlyBranch, this.explicitOnlyBranch);
        }
    }

    protected void prepareInternal() throws SailException {
        SailSource toCheckIncludeInferredBranch = this.includeInferredBranch;
        if (toCheckIncludeInferredBranch != null) {
            toCheckIncludeInferredBranch.prepare();
        }
    }

    protected void commitInternal() throws SailException {
        SailSource toCloseInferredBranch = this.includeInferredBranch;
        this.explicitOnlyBranch = null;
        this.inferredOnlyBranch = null;
        this.includeInferredBranch = null;
        try {
            if (toCloseInferredBranch != null) {
                toCloseInferredBranch.flush();
            }
        }
        finally {
            if (toCloseInferredBranch != null) {
                toCloseInferredBranch.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollbackInternal() throws SailException {
        Map<UpdateContext, SailDataset> map = this.datasets;
        synchronized (map) {
            SailDataset toCloseDataset = null;
            SailClosable toCloseExplicitSink = null;
            SailDataset toCloseExplicitOnlyDataset = this.explicitOnlyDataset;
            this.explicitOnlyDataset = null;
            SailDataset toCloseInferredDataset = this.inferredOnlyDataset;
            this.inferredOnlyDataset = null;
            SailSink toCloseInferredSink = this.inferredOnlySink;
            this.inferredOnlySink = null;
            SailSource toCloseIncludeInferredBranch = this.includeInferredBranch;
            this.includeInferredBranch = null;
            this.explicitOnlyBranch = null;
            this.inferredOnlyBranch = null;
            try {
                if (this.datasets.containsKey(null)) {
                    toCloseDataset = this.datasets.remove(null);
                }
            }
            finally {
                try {
                    if (toCloseDataset != null) {
                        toCloseDataset.close();
                    }
                }
                finally {
                    try {
                        if (this.explicitSinks.containsKey(null)) {
                            toCloseExplicitSink = this.explicitSinks.remove(null);
                        }
                    }
                    finally {
                        try {
                            if (toCloseExplicitSink != null) {
                                toCloseExplicitSink.close();
                            }
                        }
                        finally {
                            try {
                                if (toCloseExplicitOnlyDataset != null) {
                                    toCloseExplicitOnlyDataset.close();
                                }
                            }
                            finally {
                                try {
                                    if (toCloseInferredDataset != null) {
                                        toCloseInferredDataset.close();
                                    }
                                }
                                finally {
                                    try {
                                        if (toCloseInferredSink != null) {
                                            toCloseInferredSink.close();
                                        }
                                    }
                                    finally {
                                        if (toCloseIncludeInferredBranch != null) {
                                            toCloseIncludeInferredBranch.close();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startUpdate(UpdateContext op) throws SailException {
        if (op != null) {
            IsolationLevel level = this.getIsolationLevel();
            this.flush();
            Map<UpdateContext, SailDataset> map = this.datasets;
            synchronized (map) {
                SailSource source;
                assert (!this.datasets.containsKey(op));
                if (op.isIncludeInferred() && this.inferredOnlyBranch == null) {
                    SailSource explicit = this.store.getExplicitSailSource();
                    SailSource inferred = this.store.getInferredSailSource();
                    source = new UnionSailSource(explicit, inferred);
                } else {
                    source = op.isIncludeInferred() ? new UnionSailSource(this.explicitOnlyBranch, this.inferredOnlyBranch) : this.branch(IncludeInferred.explicitOnly);
                }
                this.datasets.put(op, source.dataset(level));
                this.explicitSinks.put(op, source.sink(level));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatement(UpdateContext op, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.verifyIsOpen();
        this.verifyIsActive();
        Map<UpdateContext, SailDataset> map = this.datasets;
        synchronized (map) {
            if (op == null && !this.datasets.containsKey(null)) {
                SailSource source = this.branch(IncludeInferred.explicitOnly);
                this.datasets.put(null, source.dataset(this.getIsolationLevel()));
                this.explicitSinks.put(null, source.sink(this.getIsolationLevel()));
            }
            assert (this.explicitSinks.containsKey(op));
            this.add(subj, pred, obj, this.datasets.get(op), this.explicitSinks.get(op), contexts);
        }
        this.addStatementInternal(subj, pred, obj, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatement(UpdateContext op, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.verifyIsOpen();
        this.verifyIsActive();
        Map<UpdateContext, SailDataset> map = this.datasets;
        synchronized (map) {
            if (op == null && !this.datasets.containsKey(null)) {
                SailSource source = this.branch(IncludeInferred.explicitOnly);
                this.datasets.put(null, source.dataset(this.getIsolationLevel()));
                this.explicitSinks.put(null, source.sink(this.getIsolationLevel()));
            }
            assert (this.explicitSinks.containsKey(op));
            this.remove(subj, pred, obj, this.datasets.get(op), this.explicitSinks.get(op), contexts);
        }
        this.removeStatementsInternal(subj, pred, obj, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endUpdateInternal(UpdateContext op) throws SailException {
        Map<UpdateContext, SailDataset> map = this.datasets;
        synchronized (map) {
            SailSink toCloseInferredSink = this.inferredOnlySink;
            this.inferredOnlySink = null;
            SailDataset toCloseExplicitOnlyDataset = this.explicitOnlyDataset;
            this.explicitOnlyDataset = null;
            SailDataset toCloseInferredDataset = this.inferredOnlyDataset;
            this.inferredOnlyDataset = null;
            try {
                if (toCloseInferredSink != null) {
                    toCloseInferredSink.flush();
                }
            }
            finally {
                try {
                    if (toCloseInferredSink != null) {
                        toCloseInferredSink.close();
                    }
                }
                finally {
                    try {
                        if (toCloseExplicitOnlyDataset != null) {
                            toCloseExplicitOnlyDataset.close();
                        }
                    }
                    finally {
                        try {
                            if (toCloseInferredDataset != null) {
                                toCloseInferredDataset.close();
                            }
                        }
                        finally {
                            SailSink explicit = null;
                            try {
                                explicit = this.explicitSinks.remove(op);
                                if (explicit != null) {
                                    explicit.flush();
                                }
                            }
                            finally {
                                try {
                                    if (explicit != null) {
                                        explicit.close();
                                    }
                                }
                                finally {
                                    try (SailDataset toCloseDataset = null;){
                                        toCloseDataset = this.datasets.remove(op);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addInferredStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.verifyIsOpen();
        this.verifyIsActive();
        IsolationLevel level = this.getIsolationLevel();
        Map<UpdateContext, SailDataset> map = this.datasets;
        synchronized (map) {
            if (this.inferredOnlySink == null) {
                SailSource branch = this.branch(IncludeInferred.inferredOnly);
                this.inferredOnlyDataset = branch.dataset(level);
                this.inferredOnlySink = branch.sink(level);
                this.explicitOnlyDataset = this.branch(IncludeInferred.explicitOnly).dataset(level);
            }
            boolean modified = false;
            if (contexts.length == 0) {
                if (!this.hasStatement(this.explicitOnlyDataset, subj, pred, obj, NULL_CTX)) {
                    if (!this.hasStatement(this.inferredOnlyDataset, subj, pred, obj, NULL_CTX)) {
                        this.addStatementInternal(subj, pred, obj, contexts);
                        this.notifyStatementAdded(this.vf.createStatement(subj, pred, obj));
                        modified = true;
                    }
                    this.inferredOnlySink.approve(subj, pred, obj, null);
                }
            } else {
                for (Resource ctx : contexts) {
                    if (this.hasStatement(this.explicitOnlyDataset, subj, pred, obj, ctx)) continue;
                    if (!this.hasStatement(this.inferredOnlyDataset, subj, pred, obj, ctx)) {
                        this.addStatementInternal(subj, pred, obj, new Resource[]{ctx});
                        this.notifyStatementAdded(this.vf.createStatement(subj, pred, obj, ctx));
                        modified = true;
                    }
                    this.inferredOnlySink.approve(subj, pred, obj, ctx);
                }
            }
            return modified;
        }
    }

    private void add(Resource subj, IRI pred, Value obj, SailDataset dataset, SailSink sink, Resource ... contexts) throws SailException {
        if (contexts.length == 0) {
            if (this.hasConnectionListeners() && !this.hasStatement(dataset, subj, pred, obj, NULL_CTX)) {
                this.notifyStatementAdded(this.vf.createStatement(subj, pred, obj));
            }
            sink.approve(subj, pred, obj, null);
        } else {
            for (Resource ctx : contexts) {
                if (this.hasConnectionListeners() && !this.hasStatement(dataset, subj, pred, obj, ctx)) {
                    this.notifyStatementAdded(this.vf.createStatement(subj, pred, obj, ctx));
                }
                sink.approve(subj, pred, obj, ctx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeInferredStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.verifyIsOpen();
        this.verifyIsActive();
        Map<UpdateContext, SailDataset> map = this.datasets;
        synchronized (map) {
            IsolationLevel level = this.getIsolationLevel();
            if (this.inferredOnlySink == null) {
                SailSource branch = this.branch(IncludeInferred.inferredOnly);
                this.inferredOnlyDataset = branch.dataset(level);
                this.inferredOnlySink = branch.sink(level);
                this.explicitOnlyDataset = this.branch(IncludeInferred.explicitOnly).dataset(level);
            }
            this.removeStatementsInternal(subj, pred, obj, contexts);
            return this.remove(subj, pred, obj, this.inferredOnlyDataset, this.inferredOnlySink, contexts);
        }
    }

    private boolean remove(Resource subj, IRI pred, Value obj, SailDataset dataset, SailSink sink, Resource ... contexts) throws SailException {
        if (!this.hasConnectionListeners() && sink.supportsDeprecateByQuery()) {
            return sink.deprecateByQuery(subj, pred, obj, contexts);
        }
        boolean statementsRemoved = false;
        try (CloseableIteration<? extends Statement, SailException> iter = dataset.getStatements(subj, pred, obj, contexts);){
            while (iter.hasNext()) {
                Statement st = (Statement)iter.next();
                sink.deprecate(st);
                statementsRemoved = true;
                this.notifyStatementRemoved(st);
            }
        }
        return statementsRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearInternal(Resource ... contexts) throws SailException {
        this.verifyIsOpen();
        this.verifyIsActive();
        Map<UpdateContext, SailDataset> map = this.datasets;
        synchronized (map) {
            if (!this.datasets.containsKey(null)) {
                SailSource source = this.branch(IncludeInferred.explicitOnly);
                this.datasets.put(null, source.dataset(this.getIsolationLevel()));
                this.explicitSinks.put(null, source.sink(this.getIsolationLevel()));
            }
            assert (this.explicitSinks.containsKey(null));
            if (this.hasConnectionListeners()) {
                this.remove(null, null, null, this.datasets.get(null), this.explicitSinks.get(null), contexts);
            }
            this.explicitSinks.get(null).clear(contexts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearInferred(Resource ... contexts) throws SailException {
        this.verifyIsOpen();
        this.verifyIsActive();
        Map<UpdateContext, SailDataset> map = this.datasets;
        synchronized (map) {
            if (this.inferredOnlySink == null) {
                IsolationLevel level = this.getIsolationLevel();
                SailSource branch = this.branch(IncludeInferred.inferredOnly);
                this.inferredOnlyDataset = branch.dataset(level);
                this.inferredOnlySink = branch.sink(level);
                this.explicitOnlyDataset = this.branch(IncludeInferred.explicitOnly).dataset(level);
            }
            if (this.hasConnectionListeners()) {
                this.remove(null, null, null, this.inferredOnlyDataset, this.inferredOnlySink, contexts);
            }
            this.inferredOnlySink.clear(contexts);
        }
    }

    @Override
    public void flushUpdates() throws SailException {
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setNamespaceInternal(String prefix, String name) throws SailException {
        SailSource branch = null;
        SailClosable sink = null;
        try {
            branch = this.branch(IncludeInferred.explicitOnly);
            sink = branch.sink(this.getTransactionIsolation());
            sink.setNamespace(prefix, name);
            sink.flush();
        }
        finally {
            try {
                if (sink != null) {
                    sink.close();
                }
            }
            finally {
                if (branch != null) {
                    branch.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNamespaceInternal(String prefix) throws SailException {
        SailSource branch = null;
        SailClosable sink = null;
        try {
            branch = this.branch(IncludeInferred.explicitOnly);
            sink = branch.sink(this.getTransactionIsolation());
            sink.removeNamespace(prefix);
            sink.flush();
        }
        finally {
            try {
                if (sink != null) {
                    sink.close();
                }
            }
            finally {
                if (branch != null) {
                    branch.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearNamespacesInternal() throws SailException {
        SailSource branch = null;
        SailClosable sink = null;
        try {
            branch = this.branch(IncludeInferred.explicitOnly);
            sink = branch.sink(this.getTransactionIsolation());
            sink.clearNamespaces();
            sink.flush();
        }
        finally {
            try {
                if (sink != null) {
                    sink.close();
                }
            }
            finally {
                if (branch != null) {
                    branch.close();
                }
            }
        }
    }

    private IsolationLevel getIsolationLevel() throws UnknownSailTransactionStateException {
        if (this.isActive()) {
            return this.getTransactionIsolation();
        }
        return this.defaultIsolationLevel;
    }

    private SailSource branch(IncludeInferred includeinferred) throws SailException {
        boolean isolated;
        boolean active = this.isActive();
        IsolationLevel level = this.getIsolationLevel();
        boolean bl = isolated = !IsolationLevels.NONE.isCompatibleWith(level);
        if (includeinferred == IncludeInferred.all && active && isolated) {
            return new DelegatingSailSource(this.includeInferredBranch, false);
        }
        if (includeinferred == IncludeInferred.inferredOnly && active && isolated) {
            return new DelegatingSailSource(this.inferredOnlyBranch, false);
        }
        if (active && isolated) {
            return new DelegatingSailSource(this.explicitOnlyBranch, false);
        }
        if (includeinferred == IncludeInferred.all && active) {
            return new UnionSailSource(this.store.getInferredSailSource(), this.store.getExplicitSailSource());
        }
        if (includeinferred == IncludeInferred.inferredOnly && active) {
            return this.store.getInferredSailSource();
        }
        if (active) {
            return this.store.getExplicitSailSource();
        }
        if (includeinferred == IncludeInferred.all) {
            return new UnionSailSource(this.store.getInferredSailSource().fork(), this.store.getExplicitSailSource().fork());
        }
        if (includeinferred == IncludeInferred.inferredOnly) {
            return this.store.getInferredSailSource().fork();
        }
        return this.store.getExplicitSailSource().fork();
    }

    private <T, X extends Exception> CloseableIteration<T, QueryEvaluationException> interlock(CloseableIteration<T, QueryEvaluationException> iter, SailClosable ... closes) {
        return new SailClosingIteration<T, QueryEvaluationException>(iter, closes){

            @Override
            protected void handleSailException(SailException e) throws QueryEvaluationException {
                throw new QueryEvaluationException((Throwable)e);
            }
        };
    }

    private boolean hasStatement(SailDataset dataset, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        try (CloseableIteration<? extends Statement, SailException> iter = dataset.getStatements(subj, pred, obj, contexts);){
            boolean bl = iter.hasNext();
            return bl;
        }
    }

    static enum IncludeInferred {
        all,
        explicitOnly,
        inferredOnly;


        public static IncludeInferred fromBoolean(boolean includeInferred) {
            return includeInferred ? all : explicitOnly;
        }
    }
}

