/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.concurrent.locks;

import java.util.Objects;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.IterationWrapper;

public class LockingIteration<E, X extends Exception>
extends IterationWrapper<E, X> {
    private final Lock lock;

    public LockingIteration(Lock lock, Iteration<? extends E, X> iter) {
        super(iter);
        if (iter instanceof EmptyIteration) {
            lock.release();
            this.lock = null;
        } else {
            this.lock = Objects.requireNonNull(lock);
        }
    }

    public static <T, R extends Exception> CloseableIteration<T, R> getInstance(Lock lock, CloseableIteration<T, R> iter) {
        if (iter instanceof EmptyIteration) {
            lock.release();
            return iter;
        }
        return new LockingIteration<T, R>(lock, iter);
    }

    protected void handleClose() throws X {
        try {
            super.handleClose();
        }
        finally {
            if (this.lock != null) {
                this.lock.release();
            }
        }
    }
}

