/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.IterationSpliterator;

public class Iterations {
    public static <E, X extends Exception> List<E> asList(Iteration<? extends E, X> iter) throws X {
        ArrayList list = new ArrayList();
        return Iterations.addAll(iter, list);
    }

    public static <E, X extends Exception> Set<E> asSet(Iteration<? extends E, X> iter) throws X {
        try (Stream<E> stream = iter.stream();){
            Set set = stream.collect(Collectors.toSet());
            return set;
        }
    }

    public static <E, X extends Exception, C extends Collection<E>> C addAll(Iteration<? extends E, X> iter, C collection) throws X {
        try {
            while (iter.hasNext()) {
                collection.add(iter.next());
            }
        }
        finally {
            Iterations.closeCloseable(iter);
        }
        return collection;
    }

    public static <T> Stream<T> stream(Iteration<T, ? extends Exception> iteration) {
        IterationSpliterator<T> spliterator = new IterationSpliterator<T>(iteration);
        return (Stream)StreamSupport.stream(spliterator, false).onClose(() -> {
            try {
                Iterations.closeCloseable(iteration);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static <X extends Exception> void closeCloseable(Iteration<?, X> iter) throws X {
        if (iter instanceof CloseableIteration) {
            ((CloseableIteration)iter).close();
        }
    }

    public static <X extends Exception> String toString(Iteration<?, X> iter, String separator) throws X {
        StringBuilder sb = new StringBuilder();
        Iterations.toString(iter, separator, sb);
        return sb.toString();
    }

    public static <X extends Exception> void toString(Iteration<?, X> iter, String separator, StringBuilder sb) throws X {
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(separator);
        }
    }

    public static <E, X extends Exception> Set<E> asSet(Iteration<? extends E, ? extends X> arg2, Supplier<Set<E>> setMaker) throws X {
        Set<E> set = setMaker.get();
        while (arg2.hasNext()) {
            set.add(arg2.next());
        }
        return set;
    }
}

